/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.sf.amateras.mirage.CallExecutor;
import jp.sf.amateras.mirage.IterationCallback;
import jp.sf.amateras.mirage.SqlExecutor;
import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.annotation.ResultSet;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.dialect.StandardDialect;
import jp.sf.amateras.mirage.naming.DefaultNameConverter;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.parser.Node;
import jp.sf.amateras.mirage.parser.SqlContext;
import jp.sf.amateras.mirage.parser.SqlContextImpl;
import jp.sf.amateras.mirage.parser.SqlParserImpl;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.type.DefaultValueType;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.MirageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlManagerImpl
implements SqlManager {
    private NameConverter nameConverter = new DefaultNameConverter();
    private SqlExecutor executor = new SqlExecutor();
    private CallExecutor callExecutor = new CallExecutor();
    private Dialect dialect = new StandardDialect();

    public SqlManagerImpl() {
        this.addValueType(new DefaultValueType());
        this.setNameConverter(new DefaultNameConverter());
        this.setDialect(this.dialect);
    }

    @Override
    public void setNameConverter(NameConverter nameConverter) {
        this.nameConverter = nameConverter;
        this.executor.setNameConverter(nameConverter);
        this.callExecutor.setNameConverter(nameConverter);
    }

    @Override
    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.executor.setConnectionProvider(connectionProvider);
        this.callExecutor.setConnectionProvider(connectionProvider);
    }

    @Override
    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
        this.executor.setDialect(dialect);
        this.callExecutor.setDialect(dialect);
    }

    protected Node prepareNode(String sqlPath) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = cl.getResourceAsStream(sqlPath);
        if (in == null) {
            throw new RuntimeException(String.format("resource: %s is not found.", sqlPath));
        }
        String sql = null;
        try {
            byte[] buf = new byte[8192];
            int length = 0;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
            sql = new String(out.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to load SQL from: %s", sqlPath));
        }
        Node node = new SqlParserImpl(sql).parse();
        return node;
    }

    protected SqlContext prepareSqlContext(Object param) {
        SqlContextImpl context = new SqlContextImpl();
        if (param != null) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(param);
            for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
                PropertyDesc pd = beanDesc.getPropertyDesc(i);
                context.addArg(pd.getPropertyName(), pd.getValue(param), pd.getPropertyType());
            }
        }
        return context;
    }

    @Override
    public int executeUpdate(String sqlPath) {
        return this.executeUpdate(sqlPath, null);
    }

    @Override
    public int executeUpdate(String sqlPath, Object param) {
        Node node = this.prepareNode(sqlPath);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        return this.executor.executeUpdateSql(context.getSql(), context.getBindVariables());
    }

    @Override
    public <T> List<T> getResultList(Class<T> clazz, String sqlPath) {
        return this.getResultList(clazz, sqlPath, null);
    }

    @Override
    public <T> List<T> getResultList(Class<T> clazz, String sqlPath, Object param) {
        Node node = this.prepareNode(sqlPath);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        return this.executor.getResultList(clazz, context.getSql(), context.getBindVariables());
    }

    @Override
    public <T> T getSingleResult(Class<T> clazz, String sqlPath) {
        return this.getSingleResult(clazz, sqlPath, null);
    }

    @Override
    public <T> T getSingleResult(Class<T> clazz, String sqlPath, Object param) {
        Node node = this.prepareNode(sqlPath);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        return this.executor.getSingleResult(clazz, context.getSql(), context.getBindVariables());
    }

    @Override
    public int deleteEntity(Object entity) {
        ArrayList<Object> params = new ArrayList<Object>();
        String executeSql = MirageUtil.buildDeleteSql(entity, this.nameConverter, params);
        return this.executor.executeUpdateSql(executeSql, params.toArray());
    }

    @Override
    public <T> int deleteBatch(T ... entities) {
        if (entities.length == 0) {
            return 0;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String executeSql = null;
        for (T entity : entities) {
            ArrayList<Object> params = new ArrayList<Object>();
            String sql = MirageUtil.buildDeleteSql(entity, this.nameConverter, params);
            if (executeSql == null) {
                executeSql = sql;
            } else if (!sql.equals(executeSql)) {
                throw new IllegalArgumentException("Different entity is contained in the entity list.");
            }
            paramsList.add(params.toArray());
        }
        return this.executor.executeBatchUpdateSql(executeSql, paramsList);
    }

    @Override
    public <T> int deleteBatch(List<T> entities) {
        return this.deleteBatch(entities.toArray());
    }

    @Override
    public int insertEntity(Object entity) {
        ArrayList<Object> params = new ArrayList<Object>();
        String sql = MirageUtil.buildInsertSql(entity, this.nameConverter, params);
        return this.executor.executeUpdateSql(sql, params.toArray());
    }

    @Override
    public <T> int insertBatch(T ... entities) {
        if (entities.length == 0) {
            return 0;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String executeSql = null;
        for (T entity : entities) {
            ArrayList<Object> params = new ArrayList<Object>();
            String sql = MirageUtil.buildInsertSql(entity, this.nameConverter, params);
            if (executeSql == null) {
                executeSql = sql;
            } else if (!sql.equals(executeSql)) {
                throw new IllegalArgumentException("Different entity is contained in the entity list.");
            }
            paramsList.add(params.toArray());
        }
        return this.executor.executeBatchUpdateSql(executeSql, paramsList);
    }

    @Override
    public <T> int insertBatch(List<T> entities) {
        return this.insertBatch(entities.toArray());
    }

    @Override
    public int updateEntity(Object entity) {
        ArrayList<Object> params = new ArrayList<Object>();
        String executeSql = MirageUtil.buildUpdateSql(entity, this.nameConverter, params);
        return this.executor.executeUpdateSql(executeSql, params.toArray());
    }

    @Override
    public <T> int updateBatch(T ... entities) {
        if (entities.length == 0) {
            return 0;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String executeSql = null;
        for (T entity : entities) {
            ArrayList<Object> params = new ArrayList<Object>();
            String sql = MirageUtil.buildUpdateSql(entity, this.nameConverter, params);
            if (executeSql == null) {
                executeSql = sql;
            } else if (!sql.equals(executeSql)) {
                throw new IllegalArgumentException("Different entity is contained in the entity list.");
            }
            paramsList.add(params.toArray());
        }
        return this.executor.executeBatchUpdateSql(executeSql, paramsList);
    }

    @Override
    public <T> int updateBatch(List<T> entities) {
        return this.updateBatch(entities.toArray());
    }

    @Override
    public <T> T findEntity(Class<T> clazz, Object ... id) {
        String executeSql = MirageUtil.buildSelectSQL(clazz, this.nameConverter);
        return this.executor.getSingleResult(clazz, executeSql, id);
    }

    @Override
    public void addValueType(ValueType valueType) {
        this.executor.addValueType(valueType);
        this.callExecutor.addValueType(valueType);
    }

    @Override
    public <T> int getCount(String sqlPath) {
        return this.getCount(sqlPath, null);
    }

    @Override
    public <T> int getCount(String sqlPath, Object param) {
        Node node = this.prepareNode(sqlPath);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        String sql = "SELECT COUNT(*) FROM (" + context.getSql() + ")";
        return this.executor.getSingleResult(Integer.class, sql, context.getBindVariables());
    }

    @Override
    public <T, R> R iterate(Class<T> clazz, IterationCallback<T, R> callback, String sqlPath) {
        return this.iterate(clazz, callback, sqlPath, null);
    }

    @Override
    public <T, R> R iterate(Class<T> clazz, IterationCallback<T, R> callback, String sqlPath, Object param) {
        Node node = this.prepareNode(sqlPath);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        return this.executor.iterate(clazz, callback, context.getSql(), context.getBindVariables());
    }

    @Override
    public void call(String procedureName) {
        String sql = this.toCallString(procedureName, false);
        this.callExecutor.call(sql);
    }

    @Override
    public void call(String procedureName, Object parameter) {
        String sql = this.toCallString(procedureName, parameter, false);
        this.callExecutor.call(sql, parameter);
    }

    @Override
    public <T> T call(Class<T> resultClass, String functionName) {
        String sql = this.toCallString(functionName, true);
        return this.callExecutor.call(resultClass, sql);
    }

    @Override
    public <T> T call(Class<T> resultClass, String functionName, Object param) {
        String sql = this.toCallString(functionName, param, true);
        return this.callExecutor.call(resultClass, sql, param);
    }

    @Override
    public <T> List<T> callForList(Class<T> resultClass, String functionName) {
        String sql = this.toCallString(functionName, true);
        return this.callExecutor.callForList(resultClass, sql);
    }

    @Override
    public <T> List<T> callForList(Class<T> resultClass, String functionName, Object param) {
        String sql = this.toCallString(functionName, param, true);
        return this.callExecutor.callForList(resultClass, sql, param);
    }

    protected String toCallString(String moduleName, boolean function) {
        return this.toCallString(moduleName, null, function);
    }

    protected String toCallString(String moduleName, Object param, boolean function) {
        StringBuilder sb = new StringBuilder();
        if (function) {
            sb.append("{? = call ");
        } else {
            sb.append("{call ");
        }
        sb.append(moduleName);
        sb.append("(");
        if (param != null) {
            StringBuilder p = new StringBuilder();
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(param);
            int parameterCount = 0;
            for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
                PropertyDesc pd = beanDesc.getPropertyDesc(i);
                if (!this.needsParameter(pd)) continue;
                if (parameterCount > 0) {
                    p.append(", ");
                }
                if (parameterCount >= 0) {
                    p.append("?");
                }
                ++parameterCount;
            }
            sb.append(p.toString());
        }
        sb.append(")");
        sb.append("}");
        return sb.toString();
    }

    protected boolean needsParameter(PropertyDesc pd) {
        ResultSet resultSet = pd.getAnnotation(ResultSet.class);
        if (resultSet != null) {
            return this.dialect.needsParameterForResultSet();
        }
        return true;
    }

    @Override
    public <T> List<T> getResultListBySql(Class<T> clazz, String sql) {
        return this.getResultListBySql(clazz, sql, new Object[0]);
    }

    @Override
    public <T> List<T> getResultListBySql(Class<T> clazz, String sql, Object ... params) {
        return this.executor.getResultList(clazz, sql, params);
    }

    @Override
    public <T> T getSingleResultBySql(Class<T> clazz, String sql) {
        return this.getSingleResultBySql(clazz, sql, new Object[0]);
    }

    @Override
    public <T> T getSingleResultBySql(Class<T> clazz, String sql, Object ... params) {
        return this.executor.getSingleResult(clazz, sql, params);
    }

    @Override
    public <T, R> R iterateBySql(Class<T> clazz, IterationCallback<T, R> callback, String sql) {
        return this.iterateBySql(clazz, callback, sql, new Object[0]);
    }

    @Override
    public <T, R> R iterateBySql(Class<T> clazz, IterationCallback<T, R> callback, String sql, Object ... params) {
        return this.executor.iterate(clazz, callback, sql, params);
    }

    @Override
    public int executeUpdateBySql(String sql) {
        return this.executeUpdateBySql(sql, new Object[0]);
    }

    @Override
    public int executeUpdateBySql(String sql, Object ... params) {
        return this.executor.executeUpdateSql(sql, params);
    }
}

