/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.integration.seasar;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import jp.sf.amateras.mirage.provider.DefaultConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeasarConnectionProvider
extends DefaultConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(SeasarConnectionProvider.class);
    private XADataSource xaDataSource;
    private ThreadLocal<Boolean> registered = new ThreadLocal();
    private TransactionSynchronizationRegistry syncRegistry;

    public void setXADataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry syncRegistry) {
        this.syncRegistry = syncRegistry;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn;
        if (this.syncRegistry != null && this.registered.get() == null) {
            this.syncRegistry.registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    SeasarConnectionProvider.this.releaseConnection();
                    SeasarConnectionProvider.this.registered.remove();
                }
            });
            this.registered.set(true);
        }
        if ((conn = super.getConnection()) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Get connection from XADataSource.");
            }
            conn = this.xaDataSource.getXAConnection().getConnection();
            conn.setAutoCommit(false);
            this.setConnection(conn);
        }
        return conn;
    }
}

