/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.annotation.PrimaryKey;
import jp.sf.amateras.mirage.annotation.Transient;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.naming.DefaultNameConverter;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.parser.Node;
import jp.sf.amateras.mirage.parser.SqlContext;
import jp.sf.amateras.mirage.parser.SqlContextImpl;
import jp.sf.amateras.mirage.parser.SqlParserImpl;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.util.JdbcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlManagerImpl
implements SqlManager {
    private static final Logger logger = LoggerFactory.getLogger(SqlManagerImpl.class);
    private NameConverter nameConverter = new DefaultNameConverter();
    private ConnectionProvider connectionProvider;

    @Override
    public void setNameConverter(NameConverter nameConverter) {
        this.nameConverter = nameConverter;
    }

    @Override
    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    protected Node prepareNode(String sqlPath) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = cl.getResourceAsStream(sqlPath);
        if (in == null) {
            throw new RuntimeException(String.format("resource: %s is not found.", sqlPath));
        }
        String sql = null;
        try {
            byte[] buf = new byte[8192];
            int length = 0;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
            sql = new String(out.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to load SQL from: %s", sqlPath));
        }
        Node node = new SqlParserImpl(sql).parse();
        return node;
    }

    protected SqlContext prepareSqlContext(Object param) {
        SqlContextImpl context = new SqlContextImpl();
        if (param != null) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(param);
            int i = 0;
            while (i < beanDesc.getPropertyDescSize()) {
                PropertyDesc pd = beanDesc.getPropertyDesc(i);
                context.addArg(pd.getPropertyName(), pd.getValue(param), pd.getPropertyType());
                ++i;
            }
        }
        return context;
    }

    @Override
    public int executeUpdate(String sqlPath) {
        return this.executeUpdate(sqlPath, null);
    }

    @Override
    public int executeUpdate(String sqlPath, Object param) {
        int n;
        Node node = this.prepareNode(sqlPath);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        PreparedStatement stmt = null;
        try {
            int result;
            stmt = this.connectionProvider.getConnection().prepareStatement(context.getSql());
            Object[] vars = context.getBindVariables();
            int i = 0;
            while (i < vars.length) {
                stmt.setObject(i, vars[i]);
                ++i;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(context.getSql());
            }
            n = result = stmt.executeUpdate();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(stmt);
        return n;
    }

    @Override
    public <T> List<T> getResultList(Class<T> clazz, String sqlPath) {
        return this.getResultList(clazz, sqlPath, null);
    }

    @Override
    public <T> List<T> getResultList(Class<T> clazz, String sqlPath, Object param) {
        ArrayList<T> arrayList;
        Node node = this.prepareNode(sqlPath);
        SqlContext context = this.prepareSqlContext(param);
        node.accept(context);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connectionProvider.getConnection().prepareStatement(context.getSql());
            Object[] vars = context.getBindVariables();
            int i = 0;
            while (i < vars.length) {
                stmt.setObject(i + 1, vars[i]);
                ++i;
            }
            ArrayList<T> list = new ArrayList<T>();
            if (logger.isDebugEnabled()) {
                logger.debug(context.getSql());
            }
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
            while (rs.next()) {
                T entity = this.createEntity(clazz, rs, meta, columnCount, beanDesc);
                list.add(entity);
            }
            arrayList = list;
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return arrayList;
    }

    protected <T> T createEntity(Class<T> clazz, ResultSet rs, ResultSetMetaData meta, int columnCount, BeanDesc beanDesc) throws InstantiationException, IllegalAccessException, SQLException {
        HashMap entity = null;
        entity = clazz == Map.class ? new HashMap() : (HashMap)clazz.newInstance();
        int i = 0;
        while (i < columnCount) {
            String columnName = meta.getColumnName(i + 1);
            String propertyName = this.nameConverter.columnToProperty(columnName);
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            if (pd != null) {
                Class<?> fieldType = pd.getPropertyType();
                if (fieldType == String.class) {
                    pd.setValue(entity, rs.getString(columnName));
                } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                    pd.setValue(entity, rs.getInt(columnName));
                } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                    pd.setValue(entity, rs.getLong(columnName));
                } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                    pd.setValue(entity, rs.getDouble(columnName));
                } else if (fieldType == Short.class || fieldType == Short.TYPE) {
                    pd.setValue(entity, rs.getShort(columnName));
                } else if (fieldType == Float.class || fieldType == Float.TYPE) {
                    pd.setValue(entity, Float.valueOf(rs.getFloat(columnName)));
                } else if (fieldType == BigDecimal.class) {
                    pd.setValue(entity, rs.getBigDecimal(columnName));
                } else if (fieldType == Date.class) {
                    pd.setValue(entity, rs.getTimestamp(columnName));
                }
            }
            ++i;
        }
        return (T)entity;
    }

    @Override
    public <T> T getSingleResult(Class<T> clazz, String sqlPath) {
        return this.getSingleResult(clazz, sqlPath, null);
    }

    @Override
    public <T> T getSingleResult(Class<T> clazz, String sqlPath, Object param) {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            T t;
            Node node = this.prepareNode(sqlPath);
            SqlContext context = this.prepareSqlContext(param);
            node.accept(context);
            stmt = null;
            rs = null;
            try {
                T entity;
                stmt = this.connectionProvider.getConnection().prepareStatement(context.getSql());
                Object[] vars = context.getBindVariables();
                int i = 0;
                while (i < vars.length) {
                    stmt.setObject(i + 1, vars[i]);
                    ++i;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(context.getSql());
                }
                rs = stmt.executeQuery();
                ResultSetMetaData meta = rs.getMetaData();
                int columnCount = meta.getColumnCount();
                BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
                if (!rs.next()) break block6;
                t = entity = this.createEntity(clazz, rs, meta, columnCount, beanDesc);
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException(ex);
                }
                catch (Throwable throwable) {
                    JdbcUtil.close(rs);
                    JdbcUtil.close(stmt);
                    throw throwable;
                }
            }
            JdbcUtil.close(rs);
            JdbcUtil.close(stmt);
            return t;
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return null;
    }

    @Override
    public int deleteEntity(Object entity) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(this.nameConverter.entityToTable(entity.getClass().getName()));
        sb.append(" WHERE ");
        ArrayList<Object> params = new ArrayList<Object>();
        boolean hasPrimaryKey = false;
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(entity.getClass());
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (pd.getAnnotation(PrimaryKey.class) != null && pd.isReadable()) {
                if (!params.isEmpty()) {
                    sb.append(" AND ");
                }
                sb.append(this.nameConverter.propertyToColumn(pd.getPropertyName())).append("=?");
                try {
                    params.add(pd.getValue(entity));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                hasPrimaryKey = true;
            }
            ++i;
        }
        if (!hasPrimaryKey) {
            throw new RuntimeException("Primary key is not found: " + entity.getClass());
        }
        return this.executeUpdateSql(sb.toString(), params.toArray());
    }

    @Override
    public int insertEntity(Object entity) {
        PropertyDesc pd;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(entity.getClass());
        sb.append("INSERT INTO ").append(this.nameConverter.entityToTable(entity.getClass().getName())).append(" (");
        int count = 0;
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            pd = beanDesc.getPropertyDesc(i);
            if (pd.getAnnotation(PrimaryKey.class) == null && pd.getAnnotation(Transient.class) == null && pd.isReadable()) {
                if (count != 0) {
                    sb.append(", ");
                }
                sb.append(this.nameConverter.propertyToColumn(pd.getPropertyName()));
                ++count;
            }
            ++i;
        }
        sb.append(") VALUES (");
        count = 0;
        i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            pd = beanDesc.getPropertyDesc(i);
            if (pd.getAnnotation(PrimaryKey.class) == null && pd.getAnnotation(Transient.class) == null && pd.isReadable()) {
                if (count != 0) {
                    sb.append(", ");
                }
                sb.append("?");
                try {
                    params.add(pd.getValue(entity));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                ++count;
            }
            ++i;
        }
        sb.append(")");
        return this.executeUpdateSql(sb.toString(), params.toArray());
    }

    @Override
    public int updateEntity(Object entity) {
        PropertyDesc pd;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(this.nameConverter.entityToTable(entity.getClass().getName())).append(" SET ");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(entity.getClass());
        int count = 0;
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            pd = beanDesc.getPropertyDesc(i);
            if (pd.getAnnotation(PrimaryKey.class) == null && pd.getAnnotation(Transient.class) == null && pd.isReadable()) {
                if (count != 0) {
                    sb.append(", ");
                }
                sb.append(this.nameConverter.propertyToColumn(pd.getPropertyName())).append(" = ?");
                try {
                    params.add(pd.getValue(entity));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                ++count;
            }
            ++i;
        }
        sb.append(" WHERE ");
        count = 0;
        i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            pd = beanDesc.getPropertyDesc(i);
            if (pd.getAnnotation(PrimaryKey.class) != null && pd.isReadable()) {
                if (count != 0) {
                    sb.append(" AND ");
                }
                sb.append(this.nameConverter.propertyToColumn(pd.getPropertyName())).append(" = ? ");
                try {
                    params.add(pd.getValue(entity));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            throw new RuntimeException("Primary key is not found: " + entity.getClass());
        }
        return this.executeUpdateSql(sb.toString(), params.toArray());
    }

    private int executeUpdateSql(String sql, Object ... params) {
        int n;
        PreparedStatement stmt = null;
        try {
            int result;
            Connection conn = this.connectionProvider.getConnection();
            if (logger.isDebugEnabled()) {
                logger.debug(sql);
            }
            stmt = conn.prepareStatement(sql);
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    if (params[i] instanceof Date) {
                        stmt.setTimestamp(i + 1, new Timestamp(((Date)params[i]).getTime()));
                    } else {
                        stmt.setObject(i + 1, params[i]);
                    }
                    ++i;
                }
            }
            n = result = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(stmt);
        return n;
    }
}

