package net.java.amateras.xlsbeans.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

import ognl.Ognl;

/**
 * Creates {@link java.lang.annotation.Annotation} instances
 * dynamically using Javassist.
 * 
 * @author Naoki Takezoe
 */
public class DynamicAnnotationBuilder {
	
	private static ClassLoader loader;
	
	public static void setClassLoader(ClassLoader loader){
		DynamicAnnotationBuilder.loader = loader;
	}
	
	/**
	 * Creates the annotation instance dynamically using Javaassist.
	 */
	public static Annotation buildAnnotation(final Class<?> ann, AnnotationInfo info) throws Exception {
		
		final Map<String, Object> defaultValues = new HashMap<String, Object>();
		for(Method method : ann.getMethods()){
			Object defaultValue = method.getDefaultValue();
			if(defaultValue!=null){
				defaultValues.put(method.getName(), defaultValue);
			}
		}
		
		final Map<String, Object> xmlValues = new HashMap<String, Object>();
		for(String key : info.getAnnotationAttributeKeys()){
			Object value = Ognl.getValue(info.getAnnotationAttribute(key),new Object());
			xmlValues.put(key, value);
		}
		
		Object obj = Proxy.newProxyInstance(loader, new Class[]{ann}, 
				new InvocationHandler(){
					public Object invoke(Object proxy, Method method,
							Object[] args) throws Throwable {
						String name = method.getName();
						if (name.equals("annotationType")) {
	                        return ann;
						} else if(xmlValues.containsKey(name)){
							return xmlValues.get(name);
						} else {
							return defaultValues.get(name);
	                    }
					}
		});
		
		return (Annotation)obj;
	}
	
}
