package net.java.amateras.xlsbeans.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

import junit.framework.TestCase;
import jxl.Sheet;
import net.java.amateras.xlsbeans.NeedPostProcess;
import net.java.amateras.xlsbeans.xml.AnnotationInfo;
import net.java.amateras.xlsbeans.xml.AnnotationReader;
import net.java.amateras.xlsbeans.xml.DynamicAnnotationBuilder;

public class FieldProcessorFactoryTest extends TestCase {

	public void testRegisterProcessor() throws Exception {
		SampleFieldProcessor processor = new SampleFieldProcessor();
		DynamicAnnotationBuilder.setClassLoader(getClass().getClassLoader());
		FieldProcessorFactory.registerProcessor(SampleAnnotation.class, processor);
		
		Annotation annotation = DynamicAnnotationBuilder.buildAnnotation(
				SampleAnnotation.class, new AnnotationInfo());
		
		assertSame(processor, FieldProcessorFactory.getProcessor(annotation));
	}
	
	private @interface SampleAnnotation {
	}
	
	private class SampleFieldProcessor implements FieldProcessor {
		public void doProcess(Sheet sheet, Object obj, Method setter, 
				Annotation cell, AnnotationReader reader, 
				List<NeedPostProcess> needPostProcess) throws Exception {
		}
	}
}
