// KeyMacroPlayer.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "KeyMacroPlayer.h"
#include "EditView.h"

using namespace Ascension;
using namespace std;


// CKeyMacroPlayer class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CKeyMacroPlayer::CKeyMacroPlayer() : m_kmsState(KMS_NONE), m_pActiveView(0) {
}

///	fXgN^
CKeyMacroPlayer::~CKeyMacroPlayer() {
}

/**
 *	L^̃}NɃR}hǉ
 *	@param oCommand	R}h
 */
void CKeyMacroPlayer::AddCommand(const TKeymacroCommand& oCommand) {
	AssertValid();

	if(m_kmsState == KMS_RECORDING)
		m_listRecording.push_back(oCommand);
	else
		throw EMacroIsAlreadyRunning();
}

///	L[}N̋L^𒆎~
void CKeyMacroPlayer::CancelRecording() {
	AssertValid();

	if(m_kmsState == KMS_RECORDING || m_kmsState == KMS_PAUSING) {
		m_listRecording.clear();
		StopRecording();
	}
}

///	L^Ă}N폜
void CKeyMacroPlayer::Clear() {
	AssertValid();

	if(m_kmsState == KMS_NONE)
		m_listCommands.clear();
	else
		throw EMacroIsAlreadyRunning();
}

///	B̃CX^X擾
CKeyMacroPlayer* CKeyMacroPlayer::Create() {
	static CKeyMacroPlayer	oSingleton;
	return &oSingleton;
}

/**
 *	t@CR}hXgǂݍ
 *	@param strPathName	̓t@Cnh
 *	@return				
 */
bool CKeyMacroPlayer::Load(const wstring& strPathName) {
	AssertValid();

	CFile				oInput;
	TKeymacroCommand	kmc;

	Clear();
	if(!oInput.Open(strPathName.c_str(), CFile::modeRead, false))
		return false;
	while(oInput.Read(&kmc.cmd, sizeof(kmc.cmd)) == sizeof(kmc.cmd)
			&& oInput.Read(&kmc.lParam, sizeof(kmc.lParam)) == sizeof(kmc.lParam))
		m_listCommands.push_back(kmc);
	oInput.Close();

	return true;
}

///	L^̈ꎞ~AĊJ
void CKeyMacroPlayer::Pause() {
	AssertValid();

	if(m_kmsState == KMS_RECORDING)
		m_kmsState = KMS_PAUSING;
	else if(m_kmsState == KMS_PAUSING)
		m_kmsState = KMS_RECORDING;
}

/**
 *	}N̍Đ
 *	@param oView	Ώۃr[
 */
void CKeyMacroPlayer::Play(CEditView& oView) {
	AssertValid();

	if(m_kmsState == KMS_NONE) {
		m_kmsState = KMS_PLAYING;
		m_pActiveView = &oView;
		if(!oView.GetDocument()->IsReadOnly()) {
			for(list<TKeymacroCommand>::const_iterator it = m_listCommands.begin(); it != m_listCommands.end(); ++it)
				oView.ExecCommand(it->cmd, it->lParam);
		}
		m_kmsState = KMS_NONE;
		m_pActiveView = 0;
	} else
		throw EMacroIsAlreadyRunning();
}

/**
 *	t@CɃR}hXg
 *	@param strPathName	o̓t@C
 *	@return				
 */
bool CKeyMacroPlayer::Save(const wstring& strPathName) const {
	AssertValid();

	CFile	oOutput;

	if(!oOutput.Open(strPathName.c_str(), CFile::modeWrite | CFile::modeCreate, false))
		return false;
	for(list<TKeymacroCommand>::const_iterator it = m_listCommands.begin(); it != m_listCommands.end(); ++it) {
		oOutput.Write(&it->cmd, sizeof(it->cmd));
		oOutput.Write(&it->lParam, sizeof(it->lParam));
	}
	oOutput.Close();

	return true;
}

/**
 *	}N̋L^Jn
 *	@param oView	Ώۃr[
 */
void CKeyMacroPlayer::StartRecording(CEditView& oView) {
	AssertValid();

	if(m_kmsState == KMS_NONE) {
		m_kmsState = KMS_RECORDING;
		m_pActiveView = &oView;
	} else
		throw EMacroIsAlreadyRunning();
}

///	}N̋L^I
///	R}h1ǉɏIƋL^Ă̂͂̂܂܎c
void CKeyMacroPlayer::StopRecording() {
	AssertValid();

	if(m_kmsState == KMS_RECORDING || m_kmsState == KMS_PAUSING) {
		if(!m_listRecording.empty()) {
			m_listCommands = m_listRecording;
			m_listRecording.clear();
		}
		m_kmsState = KMS_NONE;
		m_pActiveView = 0;
	}
}

/* [EOF] */