// AlphaEditController.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _ALPHA_EDIT_CONTROLLER_H_
#define _ALPHA_EDIT_CONTROLLER_H_

#include "Ascension\EditController.h"
#include "AlphaTab.h"


// CAlphaEditController class definition
/////////////////////////////////////////////////////////////////////////////

namespace Alpha {

class CAlphaDoc;
class CAlphaView;

class CAlphaEditController :
		public Ascension::CEditController,
		public IAlphaTab {
	// ^
public:
	typedef CAlphaDoc	DocumentClass;
	typedef CAlphaView	ViewClass;

	// RXgN^
public:
	CAlphaEditController();

	// \bh
public:
	bool		Create(HWND hwndParent, const RECT* lpRect,
						DWORD dwStyle, DWORD dwExStyle,
						DWORD dwViewStyle, DWORD dwViewExStyle);
	CAlphaView*	GetActiveView() const;
	CAlphaDoc*	GetDocument() const;
	CAlphaView*	GetPrimaryView() const;

	// IAlphaTab C^[tFCX
public:
	void	DeleteInstance();
	wstring	GetDescription() const;
	wstring	GetTabTitle() const;
	HWND	GetWindow() const;
	bool	IsTextEditor() const;
	void	RefreshWindow();
	void	OnActivate(bool bActive);
	bool	OnClosing();
	void	OnSize(const RECT* lpRect);

	// f[^o
private:
	unsigned short	m_iLastActiveView;	// ŌɃtH[JXĂr[̔ԍ
};


// CAlphaEditController class inline implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CEditController::GetActiveView
inline CAlphaView* CAlphaEditController::GetActiveView() const {
	AssertValid();
//	using Ascension::CEditController;	// VC6
//	return reinterpret_cast<CAlphaView*>(this->CEditController::GetActiveView());
	return reinterpret_cast<CAlphaView*>(Ascension::CEditController::GetActiveView());
}

///	@see	CController::GetDocument
inline CAlphaDoc* CAlphaEditController::GetDocument() const {
	AssertValid();
	return reinterpret_cast<CAlphaDoc*>(m_pDocument);
}

///	@see	CController::GetPrimaryView
inline CAlphaView* CAlphaEditController::GetPrimaryView() const {
	AssertValid();
//	using Ascension::CEditController;	// VC6
//	return reinterpret_cast<CAlphaView*>(this->CEditController::GetPrimaryView());
	return reinterpret_cast<CAlphaView*>(Ascension::CEditController::GetPrimaryView());
}

} // namespace Alpha


#endif /* _ALPHA_EDIT_CONTROLLER_H_ */

/* [EOF] */