// TreeCtrl.h
///////////////////////////////////////////////////////////

#ifndef _TREE_CTRL_H_
#define _TREE_CTRL_H_

#include "Window.h"
#include "ImageList.h"


// CTreeCtrl class definition
///////////////////////////////////////////////////////////

namespace Manah {
namespace Windows {
namespace Controls {

class CTreeCtrl : public CWindow {
	// RXgN^
public:
	~CTreeCtrl();

	// \bh
public:
	/* 쐬 */
	bool		Create(bool bSubClass, DWORD dwStyle, const RECT* lpRect, HWND hwndParent, UINT id);
	bool		CreateEx(bool bSubClass, DWORD dwExStyle, DWORD dwStyle, const RECT* lpRect, HWND hwndParent, UINT id);

	/*  */
	UINT		GetCount() const;
	UINT		GetIndent() const;
	void		SetIndent(UINT nIndent);
	CImageList*	GetImageList(UINT iImage) const;
	CImageList*	SetImageList(CImageList* pImageList, UINT iImage);
	HTREEITEM	GetNextItem(HTREEITEM hItem, UINT nCode) const;
	bool		ItemHasChildren(HTREEITEM hItem) const;
	HTREEITEM	GetChildItem(HTREEITEM hItem) const;
	HTREEITEM	GetNextSiblingItem(HTREEITEM hItem) const;
	HTREEITEM	GetPrevSiblingItem(HTREEITEM hItem) const;
	HTREEITEM	GetParentItem(HTREEITEM hItem) const;
	HTREEITEM	GetFirstVisibleItem() const;
	HTREEITEM	GetLastVisibleItem() const;
	HTREEITEM	GetNextVisibleItem(HTREEITEM hItem) const;
	HTREEITEM	GetPrevVisibleItem(HTREEITEM hItem) const;
	HTREEITEM	GetSelectedItem() const;
	HTREEITEM	GetDropHilightItem() const;
	HTREEITEM	GetRootItem() const;
	bool		GetItem(TVITEM* pItem) const;
	bool		SetItem(TVITEM* pItem);
	bool		SetItem(HTREEITEM hItem, UINT nMask, LPCTSTR lpszItem, int nImage, int nSelectedImage, UINT nState, UINT nStateMask, LPARAM lParam);
	UINT		GetItemState(HTREEITEM hItem, UINT nStateMask) const;
	bool		SetItemState(HTREEITEM hItem, UINT nState, UINT nStateMask);
	bool		GetItemImage(HTREEITEM hItem, int& nImage, int& nSelectedImage) const;
	bool		SetItemImage(HTREEITEM hItem, int nImage, int nSelectedImage);
	bool		GetItemText(HTREEITEM hItem, TCHAR* pszText) const;
	bool		SetItemText(HTREEITEM hItem, LPCTSTR lpszItem);
	DWORD		GetItemData(HTREEITEM hItem) const;
	bool		SetItemData(HTREEITEM hItem, DWORD dwData);
	bool		GetItemRect(HTREEITEM hItem, LPRECT lpRect, bool nTextOnly);
	HWND		GetEditControl() const;
	UINT		GetVisibleCount() const;
	HWND		GetToolTips() const;
	HWND		SetToolTips(HWND hwndToolTips);
	COLORREF	GetBkColor()const ;
	COLORREF	SetBkColor(COLORREF clr);
	SHORT		GetItemHeight() const;
	SHORT		SetItemHeight(SHORT cyHeight);
	COLORREF	GetTextColor() const;
	COLORREF	SetTextColor(COLORREF clr);
	bool		SetInsertMark(HTREEITEM hItem, bool fAfter = true);
	bool		GetCheck(HTREEITEM hItem) const;
	bool		SetCheck(HTREEITEM hItem, bool fCheck = true);
	COLORREF	GetInsertMarkColor() const;
	COLORREF	SetInsertMarkColor(COLORREF clrNew);

	/*  */
	HTREEITEM	InsertItem(LPTVINSERTSTRUCT lpInsertStruct);
	HTREEITEM	InsertItem(UINT nMask, LPCTSTR lpszItem, int iImage, int iSelectedImage, UINT nState, UINT nStateMask, LPARAM lParam, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	HTREEITEM	InsertItem(LPCTSTR lpszItem, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	HTREEITEM	InsertItem(LPCTSTR lpszItem, int iImage, int iSelectedImage, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	bool		DeleteItem(HTREEITEM hItem);
	bool		DeleteAllItems();
	bool		ExpandItem(HTREEITEM hItem, UINT nCode);
	bool		SelectItem(HTREEITEM hItem, UINT nCode = TVGN_CARET);
	bool		SelectDropTarget(HTREEITEM hItem);
	bool		SelectSetFirstVisible(HTREEITEM hItem);
	HWND		EditLabel(HTREEITEM hItem);
	HTREEITEM	HitTest(TVHITTESTINFO* lpHitTestInfo);
	HTREEITEM	HitTest(LPPOINT lpPoint, UINT nFlags);
	CImageList*	CreateDragImage(HTREEITEM hItem);	// returned pointer is permanent
	bool		SortChildren(HTREEITEM hItem);
	bool		EnsureVisible(HTREEITEM hItem);
	bool		SortChildrenCB(LPTVSORTCB pSort);
	bool		EndEditLabelNow();
	UINT		GetISearchString(LPSTR lpszText);
	UINT		GetScrollTime() const;
	UINT		SetScrollTime(UINT nScrollTime);
	bool		GetUnicodeFormat() const;
	bool		SetUnicodeFormat(bool bUnicode = true);

	/* I[o[Ch */
	bool		Attach(HWND hWnd, bool nSubClass = true);
};

} /* namespace Controls */
} /* namespace Windows */
} /* namespace Manah */


// method implementation
///////////////////////////////////////////////////////////

using Manah::Windows::Controls::CTreeCtrl;

inline CTreeCtrl::~CTreeCtrl() {
	m_hWnd = 0;
}

inline bool CTreeCtrl::Attach(HWND hWnd, bool bSubClass /* = false */) {
	AssertValid();

	if(IsWindow() || !::IsWindow(hWnd) || m_OldProc != 0)
		return false;
	m_hWnd = hWnd;

	if(bSubClass){
//		m_OldProc = reinterpret_cast<WNDPROC>(SetWindowLong(GWL_WNDPROC, reinterpret_cast<LPARAM>(g_TreeCtrlProc)));
//		assert(m_OldProc != g_TreeCtrlProc);
//		m_lOldUserData = GetWindowLong(GWL_USERDATA);
//		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}

	return true;
}

inline bool CTreeCtrl::Create(bool bSubClass, DWORD dwStyle, const RECT* lpRect, HWND hwndParent, UINT id) {
	AssertValid();

	m_hWnd = ::CreateWindow(WC_TREEVIEW, _T(""),
		dwStyle, lpRect->left, lpRect->top, lpRect->right - lpRect->left, lpRect->bottom - lpRect->top,
		hwndParent, reinterpret_cast<HMENU>(id), ::GetModuleHandle(0), 0L);
	if(m_hWnd == 0)
		return false;
	if(bSubClass){
//		m_OldProc = reinterpret_cast<WNDPROC>(SetWindowLong(GWL_WNDPROC, reinterpret_cast<LPARAM>(g_TreeCtrlProc)));
//		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}
	return true;
}

inline bool CTreeCtrl::CreateEx(bool bSubClass, DWORD dwExStyle, DWORD dwStyle, const RECT* lpRect, HWND hwndParent, UINT id) {
	AssertValid();

	m_hWnd = ::CreateWindowEx(dwExStyle, WC_TREEVIEW, _T(""),
		dwStyle, lpRect->left, lpRect->top, lpRect->right - lpRect->left, lpRect->bottom - lpRect->top,
		hwndParent, reinterpret_cast<HMENU>(id), ::GetModuleHandle(0), 0L);
	if(m_hWnd == 0)
		return false;
	if(bSubClass){
//		m_OldProc = reinterpret_cast<WNDPROC>(SetWindowLong(GWL_WNDPROC, reinterpret_cast<LPARAM>(g_TreeCtrlProc)));
//		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}
	return true;
}

inline UINT CTreeCtrl::GetCount() const {
	AssertValid();
	return static_cast<UINT>(::SendMessage(m_hWnd, TVM_GETCOUNT, 0, 0L));
}

inline UINT CTreeCtrl::GetIndent() const {
	AssertValid();
	return static_cast<UINT>(::SendMessage(m_hWnd, TVM_GETINDENT, 0, 0L));
}

inline void CTreeCtrl::SetIndent(UINT nIndent) {
	SendMessage(TVM_SETINDENT, nIndent);
}

inline Manah::Windows::CImageList* CTreeCtrl::GetImageList(UINT iImage) const {
	return CImageList::FromHandle(
		reinterpret_cast<HIMAGELIST>(::SendMessage(m_hWnd, TVM_GETIMAGELIST, iImage, 0L)));
}

inline Manah::Windows::CImageList* CTreeCtrl::SetImageList(Manah::Windows::CImageList* pImageList, UINT iImage) {
	return CImageList::FromHandle(reinterpret_cast<HIMAGELIST>(
		SendMessage(TVM_SETIMAGELIST, iImage, reinterpret_cast<LPARAM>(pImageList->GetSafeHandle()))));
}

inline HTREEITEM CTreeCtrl::GetNextItem(HTREEITEM hItem, UINT nCode) const {
	AssertValid();
	return reinterpret_cast<HTREEITEM>(
		::SendMessage(m_hWnd, TVM_GETNEXTITEM, nCode, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::ItemHasChildren(HTREEITEM hItem) const {
	AssertValid();

	TVITEM item;
	item.hItem = hItem;
	item.mask = TVIF_CHILDREN;

	::SendMessage(m_hWnd, TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item));

	return (item.cChildren != 0);
}

inline HTREEITEM CTreeCtrl::GetChildItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_CHILD);
}

inline HTREEITEM CTreeCtrl::GetNextSiblingItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_NEXT);
}

inline HTREEITEM CTreeCtrl::GetPrevSiblingItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_PREVIOUS);
}

inline HTREEITEM CTreeCtrl::GetParentItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_PARENT);
}

inline HTREEITEM CTreeCtrl::GetFirstVisibleItem() const {
	return GetNextItem(0, TVGN_FIRSTVISIBLE);
}

inline HTREEITEM CTreeCtrl::GetLastVisibleItem() const {
	return GetNextItem(0, TVGN_LASTVISIBLE);
}

inline HTREEITEM CTreeCtrl::GetNextVisibleItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_NEXTVISIBLE);
}

inline HTREEITEM CTreeCtrl::GetPrevVisibleItem(HTREEITEM hItem) const {
	return GetNextItem(hItem, TVGN_PREVIOUSVISIBLE);
}

inline HTREEITEM CTreeCtrl::GetSelectedItem() const {
	return GetNextItem(0, TVGN_CARET);
}

inline HTREEITEM CTreeCtrl::GetDropHilightItem() const {
	return GetNextItem(0, TVGN_DROPHILITE);
}

inline HTREEITEM CTreeCtrl::GetRootItem() const {
	return GetNextItem(0, TVGN_ROOT);
}

inline bool CTreeCtrl::GetItem(TVITEM* pItem) const {
	AssertValid();
	return toBoolean(::SendMessage(m_hWnd, TVM_GETITEM, 0, reinterpret_cast<LPARAM>(pItem)));
}

inline bool CTreeCtrl::SetItem(TVITEM* pItem) {
	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(pItem)));
}

inline bool CTreeCtrl::SetItem(
	HTREEITEM hItem, UINT nMask, LPCTSTR lpszItem,
	int nImage, int nSelectedImage, UINT nState, UINT nStateMask, LPARAM lParam) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = nMask;
	item.pszText = const_cast<LPTSTR>(lpszItem);
	item.iImage = nImage;
	item.iSelectedImage = nSelectedImage;
	item.state = nState;
	item.stateMask = nStateMask;
	item.lParam = lParam;

	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline UINT CTreeCtrl::GetItemState(HTREEITEM hItem, UINT nStateMask) const {
	AssertValid();

	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_STATE;
	item.stateMask = nStateMask;
	item.state = 0;
	::SendMessage(m_hWnd, TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item));

	return item.state;
}

inline bool CTreeCtrl::SetItemState(HTREEITEM hItem, UINT nState, UINT nStateMask) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_STATE;
	item.stateMask = nStateMask;
	item.state = nState;

	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::GetItemImage(HTREEITEM hItem, int& nImage, int& nSelectedImage) const {
	AssertValid();

	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	if(::SendMessage(m_hWnd, TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item))){
		nImage = item.iImage;
		nSelectedImage = item.iSelectedImage;

		return true;
	}else
		return false;
}

inline bool CTreeCtrl::SetItemImage(HTREEITEM hItem, int nImage, int nSelectedImage) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	item.iImage = nImage;
	item.iSelectedImage = nSelectedImage;

	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::GetItemText(HTREEITEM hItem, TCHAR* pszText) const {
	AssertValid();

	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_TEXT;
	item.pszText = pszText;
	item.cchTextMax = _tcslen(pszText) + 1;
	if(::SendMessage(m_hWnd, TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item))){
		pszText = item.pszText;
		return true;
	}else
		return false;
}

inline bool CTreeCtrl::SetItemText(HTREEITEM hItem, LPCTSTR lpszItem) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_TEXT;
	item.pszText = const_cast<LPTSTR>(lpszItem);

	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline DWORD CTreeCtrl::GetItemData(HTREEITEM hItem) const {
	AssertValid();

	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_PARAM;
	::SendMessage(m_hWnd, TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item));

	return item.lParam;
}

inline bool CTreeCtrl::SetItemData(HTREEITEM hItem, DWORD dwData) {
	TVITEM item;

	item.hItem = hItem;
	item.mask = TVIF_PARAM;
	item.lParam = dwData;

	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline bool CTreeCtrl::GetItemRect(HTREEITEM hItem, LPRECT lpRect, bool bTextOnly) {
	lpRect = reinterpret_cast<LPRECT>(hItem);
	return toBoolean(SendMessage(TVM_GETITEMRECT, bTextOnly, reinterpret_cast<LPARAM>(lpRect)));
}

inline HWND CTreeCtrl::GetEditControl() const {
	AssertValid();
	return reinterpret_cast<HWND>(::SendMessage(m_hWnd, TVM_GETEDITCONTROL, 0, 0L));
}

inline UINT CTreeCtrl::GetVisibleCount() const {
	AssertValid();
	return static_cast<UINT>(::SendMessage(m_hWnd, TVM_GETVISIBLECOUNT, 0, 0L));
}

inline HWND CTreeCtrl::GetToolTips() const {
	AssertValid();
	return reinterpret_cast<HWND>(::SendMessage(m_hWnd, TVM_GETTOOLTIPS, 0, 0L));
}

inline HWND CTreeCtrl::SetToolTips(HWND hwndTooltip) {
	return reinterpret_cast<HWND>(SendMessage(TVM_SETTOOLTIPS, 0, reinterpret_cast<LPARAM>(hwndTooltip)));
}

inline COLORREF CTreeCtrl::GetBkColor() const {
	AssertValid();
	return static_cast<COLORREF>(::SendMessage(m_hWnd, TVM_GETBKCOLOR, 0, 0L));
}

inline COLORREF CTreeCtrl::SetBkColor(COLORREF clr) {
	return static_cast<COLORREF>(SendMessage(TVM_SETBKCOLOR, 0, static_cast<LPARAM>(clr)));
}

inline SHORT CTreeCtrl::GetItemHeight() const {
	AssertValid();
	return static_cast<short>(::SendMessage(m_hWnd, TVM_GETITEMHEIGHT, 0, 0L));
}

inline SHORT CTreeCtrl::SetItemHeight(SHORT cyHeight) {
	return static_cast<short>(SendMessage(TVM_SETITEMHEIGHT, cyHeight));
}

inline COLORREF CTreeCtrl::GetTextColor() const {
	AssertValid();
	return static_cast<COLORREF>(::SendMessage(m_hWnd, TVM_GETTEXTCOLOR, 0, 0L));
}

inline COLORREF CTreeCtrl::SetTextColor(COLORREF clr) {
	return static_cast<COLORREF>(SendMessage(TVM_SETTEXTCOLOR, clr));
}

inline bool CTreeCtrl::SetInsertMark(HTREEITEM hItem, bool fAfter /* = true */) {
	return toBoolean(SendMessage(TVM_SETINSERTMARK, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::GetCheck(HTREEITEM hItem) const {
	AssertValid();

	TVITEM item;

	item.mask = TVIF_HANDLE | TVIF_STATE;
	item.hItem = hItem;
	item.stateMask = TVIS_STATEIMAGEMASK;
	::SendMessage(m_hWnd, TVM_GETITEM, 0, reinterpret_cast<LPARAM>(&item));

	return toBoolean(static_cast<UINT>(item.state >> 12) -1);
}

inline bool CTreeCtrl::SetCheck(HTREEITEM hItem, bool fCheck /* = true */) {
	TVITEM item;

	item.mask = TVIF_HANDLE | TVIF_STATE;
	item.hItem = hItem;
	item.stateMask = TVIS_STATEIMAGEMASK;
	item.state = INDEXTOSTATEIMAGEMASK((fCheck ? 2 : 1));

	return toBoolean(SendMessage(TVM_SETITEM, 0, reinterpret_cast<LPARAM>(&item)));
}

inline COLORREF CTreeCtrl::GetInsertMarkColor() const {
	AssertValid();
	return static_cast<COLORREF>(::SendMessage(m_hWnd, TVM_GETINSERTMARKCOLOR, 0, 0L));
}

inline COLORREF CTreeCtrl::SetInsertMarkColor(COLORREF clrNew) {
	return static_cast<COLORREF>(SendMessage(TVM_SETINSERTMARKCOLOR, clrNew));
}

inline HTREEITEM CTreeCtrl::InsertItem(LPTVINSERTSTRUCT lpInsertStruct) {
	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_INSERTITEM, 0, reinterpret_cast<LPARAM>(lpInsertStruct)));
}

inline HTREEITEM CTreeCtrl::InsertItem(
	UINT nMask, LPCTSTR lpszItem, int nImage, int nSelectedImage,
	UINT nState, UINT nStateMask, LPARAM lParam, HTREEITEM hParent, HTREEITEM hInsertAfter) {
	TVINSERTSTRUCT tvis;

	tvis.hParent = hParent;
	tvis.hInsertAfter = hInsertAfter;
	tvis.item.mask = nMask;
	tvis.item.pszText = (LPTSTR)lpszItem;
	tvis.item.iImage = nImage;
	tvis.item.iSelectedImage = nSelectedImage;
	tvis.item.state = nState;
	tvis.item.stateMask = nStateMask;
	tvis.item.lParam = lParam;

	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_INSERTITEM, 0, reinterpret_cast<LPARAM>(&tvis)));
}

inline HTREEITEM CTreeCtrl::InsertItem(
	LPCTSTR lpszItem, HTREEITEM hParent /* = TVI_ROOT */, HTREEITEM hInsertAfter /* = TVI_LAST */) {
	TVINSERTSTRUCT tvis;

	tvis.hParent = hParent;
	tvis.hInsertAfter = hInsertAfter;
	tvis.item.mask = TVIF_TEXT;
	tvis.item.pszText = const_cast<LPTSTR>(lpszItem);

	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_INSERTITEM, 0, reinterpret_cast<LPARAM>(&tvis)));
}

inline HTREEITEM CTreeCtrl::InsertItem(
	LPCTSTR lpszItem, int nImage, int nSelectedImage,
	HTREEITEM hParent /* = TVI_ROOT */, HTREEITEM hInsertAfter /* = TVI_LAST */) {
	TVINSERTSTRUCT tvis;

	tvis.hParent = hParent;
	tvis.hInsertAfter = hInsertAfter;
	tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvis.item.pszText = const_cast<LPTSTR>(lpszItem);
	tvis.item.iImage = nImage;
	tvis.item.iSelectedImage = nSelectedImage;

	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_INSERTITEM, 0, reinterpret_cast<LPARAM>(&tvis)));
}

inline bool CTreeCtrl::DeleteItem(HTREEITEM hItem) {
	return toBoolean(SendMessage(TVM_DELETEITEM, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::DeleteAllItems() {
	return toBoolean(SendMessage(TVM_DELETEITEM, 0, reinterpret_cast<LPARAM>(TVI_ROOT)));
}

inline bool CTreeCtrl::ExpandItem(HTREEITEM hItem, UINT nCode) {
	return toBoolean(SendMessage(TVM_EXPAND, nCode, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::SelectItem(HTREEITEM hItem, UINT nCode /* = TVGN_CARET */) {
	return toBoolean(SendMessage(TVM_SELECTITEM, nCode, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::SelectDropTarget(HTREEITEM hItem) {
	return toBoolean(SendMessage(TVM_SELECTITEM, TVGN_DROPHILITE, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::SelectSetFirstVisible(HTREEITEM hItem) {
	return toBoolean(SendMessage(TVM_SELECTITEM, TVGN_FIRSTVISIBLE, reinterpret_cast<LPARAM>(hItem)));
}

inline HWND CTreeCtrl::EditLabel(HTREEITEM hItem) {
	return reinterpret_cast<HWND>(SendMessage(TVM_EDITLABEL, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline HTREEITEM CTreeCtrl::HitTest(TVHITTESTINFO* lpHitTestInfo) {
	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_HITTEST, 0, reinterpret_cast<LPARAM>(lpHitTestInfo)));
}

inline HTREEITEM CTreeCtrl::HitTest(LPPOINT lpPoint, UINT nFlags) {
	TVHITTESTINFO tvhti;

	tvhti.flags = nFlags;
	tvhti.pt = *lpPoint;

	return reinterpret_cast<HTREEITEM>(SendMessage(TVM_HITTEST, 0, reinterpret_cast<LPARAM>(&tvhti)));
}

inline Manah::Windows::CImageList* CTreeCtrl::CreateDragImage(HTREEITEM hItem) {
	return CImageList::FromHandlePermanent(reinterpret_cast<HIMAGELIST>(
		SendMessage(TVM_CREATEDRAGIMAGE, 0, reinterpret_cast<LPARAM>(hItem))));
}

inline bool CTreeCtrl::SortChildren(HTREEITEM hItem) {
	return toBoolean(SendMessage(TVM_SORTCHILDREN, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::EnsureVisible(HTREEITEM hItem) {
	return toBoolean(SendMessage(TVM_ENSUREVISIBLE, 0, reinterpret_cast<LPARAM>(hItem)));
}

inline bool CTreeCtrl::SortChildrenCB(LPTVSORTCB pSort) {
	return toBoolean(SendMessage(TVM_SORTCHILDRENCB, 0, reinterpret_cast<LPARAM>(pSort)));
}

inline bool CTreeCtrl::EndEditLabelNow() {
	return toBoolean(SendMessage(TVM_ENDEDITLABELNOW));
}

inline UINT CTreeCtrl::GetISearchString(LPSTR lpszText) {
	return static_cast<UINT>(SendMessage(TVM_GETISEARCHSTRING, 0, reinterpret_cast<LPARAM>(lpszText)));
}

inline UINT CTreeCtrl::GetScrollTime() const {
	AssertValid();
	return static_cast<UINT>(::SendMessage(m_hWnd, TVM_GETSCROLLTIME, 0, 0L));
}

inline UINT CTreeCtrl::SetScrollTime(UINT nScrollTime) {
	return static_cast<UINT>(SendMessage(TVM_SETSCROLLTIME, nScrollTime));
}

inline bool CTreeCtrl::GetUnicodeFormat() const {
	AssertValid();
	return toBoolean(::SendMessage(m_hWnd, TVM_GETUNICODEFORMAT, 0, 0L));
}

inline bool CTreeCtrl::SetUnicodeFormat(bool bUnicode /* = true */) {
	return toBoolean(SendMessage(TVM_SETUNICODEFORMAT, bUnicode));
}

#endif /* _TREE_CTRL_H_ */

/* [EOF] */