// TextSearcher.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "TextSearcher.h"
#include "..\..\Manah\TextConverter.h"
#include "VBScript_RegExp.tlh"
using namespace Ascension;
using namespace VBScript_RegExp_55;
using Manah::CTextConverter;


// CTextSearcher class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextSearcher::CTextSearcher() : m_pRegExp(0) {
}

///	fXgN^
CTextSearcher::~CTextSearcher() {
	if(m_pRegExp != 0)
		m_pRegExp->Release();
}

/**
 *	s
 *	@param iBegin	Jnʒu
 *	@param iFound	[out] ʒu
 *	@param cchFound	[out] ̒
 *	@return			ǂ
 *	@throw EFailedToLoadRegExpEngine
 *					K\GW̓ǂݍ݂Ɏs
 */
bool CTextSearcher::Search(size_t iBegin,
		size_t& iFound, size_t& cchFound) throw(EFailedToLoadRegExpEngine) {
	AssertValid();

	if(toBoolean(m_sfFlags & SF_REGEXP) && m_pRegExp == 0) {
		CLSID	clsid;
		HRESULT	hr;

		hr = ::CLSIDFromProgID(OLESTR("VBScript.RegExp"), &clsid);
		if(SUCCEEDED(hr))
			hr = ::CoCreateInstance(clsid, 0,
				CLSCTX_INPROC, __uuidof(IRegExp), reinterpret_cast<void**>(&m_pRegExp));
		if(FAILED(hr)) {
			void*	lpMsgBuf = 0;

			::FormatMessageW(FORMAT_MESSAGE_ALLOCATE_BUFFER
				| FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
				0, ::GetLastError(), LANG_USER_DEFAULT, reinterpret_cast<wchar_t*>(&lpMsgBuf), 0, 0);
			wstring	str = static_cast<wchar_t*>(lpMsgBuf);
			::LocalFree(lpMsgBuf);
			throw EFailedToLoadRegExpEngine(str);
		}
	}

	// 
	iFound = iBegin;
	do {
		if(toBoolean(m_sfFlags & SF_BACKWARD))	// O
			iFound = m_strTarget.rfind(m_strFindWhat, iFound - 1);
		else						// 
			iFound = m_strTarget.find(m_strFindWhat, iFound);
		if(iFound == wstring::npos)
			break;
		if(!toBoolean(m_sfFlags & SF_WHOLEWORD)
				|| (CTextConverter::HasWordBorderAt(m_strTarget.c_str(), iFound)
				&& CTextConverter::HasWordBorderAt(m_strTarget.c_str(), iFound + m_strTarget.length()))) {
			cchFound = m_strFindWhat.length();
			return true;
		}
		iFound += (toBoolean(m_sfFlags & SF_BACKWARD) ? -1 : 1);
	} while(true);

	return false;
}

///	tO̐ݒ
void CTextSearcher::SetFlag(SearchFlag flags) {
	AssertValid();
	m_sfFlags = flags;
}

///	̐ݒ
void CTextSearcher::SetText(const wstring& strText) {
	AssertValid();

	size_t		cch = strText.length();
	wchar_t*	pwsz = new wchar_t[cch];
	wcsncpy(pwsz, strText.c_str(), cch);

	if(toBoolean(m_sfFlags & SF_IGNORE_CASE_SIMPLE))
		::CharLowerBuffW(pwsz, cch);
	if(toBoolean(m_sfFlags & SF_IGNORE_KANATYPE))
		CTextConverter::ToHiragana(pwsz, cch);

	m_strFindWhat.assign(pwsz, cch);
	delete[] pwsz;
}

///	Ώە̐ݒ
void CTextSearcher::SetTargetText(const wstring& strText) {
	AssertValid();

	size_t		cch = strText.length();
	wchar_t*	pwsz = new wchar_t[cch];
	wcsncpy(pwsz, strText.c_str(), cch);

	if(toBoolean(m_sfFlags & SF_IGNORE_CASE_SIMPLE))
		::CharLowerBuffW(pwsz, cch);
	if(toBoolean(m_sfFlags & SF_IGNORE_KANATYPE))
		CTextConverter::ToHiragana(pwsz, cch);

	m_strTarget.assign(pwsz, cch);
	delete[] pwsz;
}

/* [EOF] */