/**
 * ActionKey2Session.java
 * Created on 2004/02/20
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.view.decorator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import net.prixdami.alexis.Const;
import net.prixdami.alexis.view.Decorator;

import org.apache.velocity.VelocityContext;


/**
 * ev[gɖߍ܂ꂽANVL[ZbVɗ
 * @author es
 */
public class ActionKey2Session extends Decorator {

    /* ( Javadoc)
     * @see net.prixdami.alexis.view.Decorator#decorate(org.apache.velocity.VelocityContext, javax.servlet.http.HttpServletRequest)
     */
    public VelocityContext decorate(VelocityContext context, HttpServletRequest request) {
		HttpSession s = request.getSession(true);
		String key = (String) context.get(Const.ACTION_NAME);
		String value = (String) context.get(Const.ACTION_KEY);
		s.setAttribute(key, value);
        return context;
    }

    /* ( Javadoc)
     * @see net.prixdami.alexis.view.Decorator#init()
     */
	public void init() {
    }

}
