/**
 * DecoratorChain.java
 * Created on 2004/02/20
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.view;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import net.prixdami.alexis.exception.DecorationException;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;

/**
 * urlp^[ɑ΂ĎgpDecoratořQW
 * @author es
 */
public class DecoratorChain {

	ArrayList[] decorators;

	/**
	 * w肳ꂽurlp^[ɍvDecoratorChain擾
     * @param url urlp^[
     * @return@ɍvDecoratorChainA`Ȃꍇnull
     */
    public static DecoratorChain getChain(String url) {
    	//DecoratorǗNXւ̈Ϗ
    	//DecoratorǗNX̓pbP[WvCx[gȂ̂
    	//̃\bhȊODecoratorChaiñCX^X͎Ȃ
		return DecoratorManager.getDecoratorChain(url);
	}
	
	/**
     * O̓CX^X𐶐Ȃ
     */
    DecoratorChain() {
		decorators = new ArrayList[2];
		//0̓}[WOɎgpDecorator̈ꗗ
		decorators[0] = new ArrayList();
		//1̓}[WɎgpDecorator̈ꗗ
		decorators[1] = new ArrayList();
	}
	
	/**
	 * ev[gɑ΂ĈÃev[gs
     * @param template@Ώۂ̃ev[g
     * @param request ev[gĂ΂ꂽHTTPNGXg
     * @return@ev[g̃eLXg܂Writer
     * @throws Exception@炩̗O
     */
    public Writer execute(Template template, HttpServletRequest request) throws DecorationException {
    	try {
	        Writer writer = new StringWriter();
			VelocityContext c = new VelocityContext();
			Decorator d;
	
			for(int i=0; i < decorators[0].size(); i++) {
				d = (Decorator) decorators[0].get(i);
				d.init();
				c = d.decorate(c, request);
			}
	
			template.merge(c, writer);
	
			for(int i=0; i < decorators[1].size(); i++) {
				d = (Decorator) decorators[1].get(i);
				d.init();
				d.decorate(c, request);
			}
	
			return writer;
		} catch(Exception e) {
			throw new DecorationException(e);
		}
	}
}
