/**
 * MultipartParser.java
 * Created on 2003/06/05
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Must not change/append/modify this list of conditions and the 
 *    following disclaimer, if you altered this source code.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.multipart;

import java.io.IOException;
import java.util.Map;

import javax.servlet.ServletRequest;

/**
 * MultipartParser
 * @author es
 * @version 1.0
 */
public class MultipartParser {
    private MultipartStripper stripper;
    private static MultipartParser me = new MultipartParser();

    private MultipartParser(){
        String encode = System.getProperty("Multipart.encoding", "JISAutoDetect");
        int flag = Integer.parseInt(System.getProperty("Multipart.filesaveflag", "1"));
        String path = System.getProperty("Multipart.filesavepath", "/data/");
        stripper = new MultipartStripper(encode, flag, path);
    }

    public static MultipartParser getInstance(){
        return me;
    }

    public Map parse(ServletRequest request, int maxsize) throws IOException{
        return stripper.strip(request, maxsize);
    }
}