/**
 * ViewController.java
 * Created on 2004/02/18
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.prixdami.alexis.Const;
import net.prixdami.alexis.exception.Recoverable;
import net.prixdami.alexis.system.SystemParameter;
import net.prixdami.alexis.view.DecoratorChain;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;

/**
 * html̃ev[gsRg[
 * @author es
 */
public class ViewController extends GenericServlet {

    private static final String ENCODE = Const.SYSTEM_ENCODEING;

    private String systemFatalTo;

    /**
     * ev[gs
     * @param request
     * @param response
     */
    private void exec(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        //GETvꂽ\[X擾
        String uri = req.getRequestURI().substring(1);
        Template template = null;
		Writer sw;

        try {
        	//ev[g擾
			template = Velocity.getTemplate(uri, ENCODE);
			//ev[gCNX擾
			DecoratorChain dc = DecoratorChain.getChain(uri);

			if(dc == null) {
				sw = withoutDecoration(uri);
			} else {
				sw = dc.execute(template, req);
			}

			res.setStatus(HttpServletResponse.SC_OK);
            res.setContentType("text/html; charset=" + ENCODE);
            PrintWriter out = res.getWriter();
            out.write(sw.toString());

        } catch (ResourceNotFoundException e) {
			//ev[gꍇ404ŏI
            res.sendError(HttpServletResponse.SC_NOT_FOUND);
        } catch (Recoverable r) {
            //WԂIE500ԂƃT[o[ŗpӂRec𖳎ۂ̂
            //{ɗ\s\ȕȊO̓G[p̃y[W200ŃfBXpb`
            req.setAttribute(Const.KEY_EXCEPTION, r);
            RequestDispatcher rd = req.getRequestDispatcher(systemFatalTo);
            rd.forward(req, res);
        } catch (Exception e) {
            throw new ServletException(e);
        }
    }

    /* ( Javadoc)
     * @see javax.servlet.Servlet#init(javax.servlet.ServletConfig)
     */
    public void init(ServletConfig arg0) throws ServletException {
        //͂servlet߂ČĂ΂ꂽƂ1񂾂ʂ
        try {
            systemFatalTo = SystemParameter.getSystemProperty(Const.SYSTEM_FATAL);
            Velocity.init(SystemParameter.getProperties(this.getClass().getName()));
        } catch (Exception e) {
            //OServletExceptionɒuăRei500G[ɂ
            throw new ServletException(e);
        }
    }

    /* ( Javadoc)
     * @see javax.servlet.GenericServlet#service(javax.servlet.ServletRequest, javax.servlet.ServletResponse)
     */
    public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
        exec((HttpServletRequest) arg0, (HttpServletResponse) arg1);
    }

    /**
     * ev[gvȂꍇ
     * @param uri
     */
    private Writer withoutDecoration(String uri) throws Exception {
        // TODO ^ʖڂɎ
		Writer w = new StringWriter();
		Context c = new VelocityContext();
		Template t = Velocity.getTemplate(uri, ENCODE);
		t.merge(c, w);
        return w;
    }

}
