/**
 * NormalController.java
 * Created on 2003/05/03
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.controller;

import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import net.prixdami.alexis.Const;
import net.prixdami.alexis.exception.InvalidParameterException;
import net.prixdami.alexis.exception.Recoverable;
import net.prixdami.alexis.logic.*;
import net.prixdami.alexis.logic.LogicParameter;
import net.prixdami.alexis.model.ResultModel;

/**
 * ʏtH[pRg[.
 * 
 * ʏformsubmitSĂservletɂĂ悢
 * HTMLform"action"p[^Ŏw肳ĂANVfVXep[^擾A
 * ̃ANVfێĂLogicsAʂɉʑJڂ
 * 
 * KΏۂHTMLtH[actionHttpSessionł̓eID𖄂ߍނ<br>
 * <p>̗<br>
 * input name="action" value="(ActionCode)"<br>
 * input name="(ActionCode)" value="(eID)"<br>
 * session.setAttribute("(ActionCode)", "(eID)");
 * 
 * @author es
 * @version 1.2
 */
public class NormalController extends GenericController {

    /* ( Javadoc)
     * @see net.prixdami.alexis.controller.GenericController#action(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected String action(HttpServletRequest req, HttpServletResponse res) throws javax.servlet.ServletException, java.io.IOException {

        HttpSession session = req.getSession();
        int resultCode;
        String returnPath = null;
		LogicParameter requestMap = new LogicParameter(req);

        try {
            //ActionR[h`FbN
            String action = req.getParameter(ACTION);
            if (action == null || action.equals("")) {
                throw new InvalidParameterException("@\R[hĂ܂");
            }

            //ActionL[`FbN
            String key_session = (String) session.getAttribute(action);
            String key_param = (String) req.getParameter(action);
            if (key_session == null || key_param == null || !key_session.equals(key_param)) {
                throw new InvalidParameterException("񐳋KANZXm@\");
            }

            //Logics
            ActionModel am = getAction(action);

            ResultModel result = getLogic(am).invoke(requestMap);
            if(result.getResultCode() == ResultModel.NOTICE) {
				session.setAttribute(Const.KEY_ERRORMESSAGE, result.getResult().toString());
            }            
            session.setAttribute(RESULT, result.getResult());
            returnPath = getReturnPath(result.getResultCode(), am, requestMap.get(LogicParameter.PARAM_REF));

        } catch (Recoverable r) {
            req.setAttribute(KEY_EXCEPTION, r);
            //WԂIE500ԂƃT[o[ŗpӂRec𖳎ۂ̂
            //{ɗ\s\ȕȊO̓G[p̃y[W200ŃfBXpb`
            String url = systemFatalTo.equals(Const.SYSTEM_SELF) ? null : systemFatalTo;
            RequestDispatcher rd = req.getRequestDispatcher(url);
			if(rd == null) {
				//fBXpb`Ȃ炨グ
				req.setAttribute(KEY_EXCEPTION, new InvalidParameterException("VXep[^̃G[y[Wݒ肪sK؂ł"));
				res.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
			}
            rd.forward(req, res);
            return null;
        } catch (Exception ex) {
            req.setAttribute(KEY_EXCEPTION, ex);
            res.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        }
        return returnPath;
    }

    /* ( Javadoc)
     * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws javax.servlet.ServletException, java.io.IOException {
        String path = action(req, res);
        if (path != null) {
			res.sendRedirect(path);
        }
    }

    /* ( Javadoc)
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws javax.servlet.ServletException, java.io.IOException {
        String path = action(req, res);
        if (path != null) {
			res.sendRedirect(path);
        }
    }
}