/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.BlockLinkChecker;
import edu.mit.blocks.codeblocks.BlockStub;
import edu.mit.blocks.renderable.BlockNode;
import edu.mit.blocks.renderable.FactoryRenderableBlock;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.renderable.TextualFactoryBlock;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceWidget;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class BlockUtilities {
    private static final Map<String, Integer> instanceCounter = new HashMap<String, Integer>();
    private static double zoom = 1.0;

    public static void reset() {
        zoom = 1.0;
        instanceCounter.clear();
    }

    public static void setZoomLevel(double newZoom) {
        zoom = newZoom;
    }

    public static boolean isLabelValid(Workspace workspace, Long blockID, String label) {
        return BlockUtilities.isLabelValid(workspace.getEnv().getBlock(blockID), label);
    }

    public static boolean isLabelValid(Block block, String label) {
        if (block == null || label == null) {
            return false;
        }
        if (block.labelMustBeUnique()) {
            Workspace workspace = block.getWorkspace();
            for (RenderableBlock rb : workspace.getRenderableBlocksFromGenus(block.getGenusName())) {
                if (!label.equals(rb.getBlock().getBlockLabel())) continue;
                return false;
            }
        }
        return true;
    }

    public static void deleteBlock(RenderableBlock block) {
        Container parent;
        block.setLocation(0, 0);
        WorkspaceWidget widget = block.getParentWidget();
        if (widget != null) {
            widget.removeBlock(block);
        }
        if ((parent = block.getParent()) != null) {
            parent.remove(block);
            parent.validate();
        }
        block.setParentWidget(null);
        Workspace workspace = block.getWorkspace();
        workspace.notifyListeners(new WorkspaceEvent(workspace, widget, block.getBlockID(), 4));
    }

    public static RenderableBlock cloneBlock(Block myblock) {
        Block block;
        String mygenusname = myblock.getGenusName();
        String label = myblock.getBlockLabel();
        Workspace workspace = myblock.getWorkspace();
        if (!myblock.getInitialLabel().equals(myblock.getBlockLabel())) {
            int prefixLength = myblock.getLabelPrefix().length();
            int suffixLength = myblock.getLabelSuffix().length();
            if (prefixLength > 0 || suffixLength > 0) {
                label = myblock.getBlockLabel().substring(prefixLength, myblock.getBlockLabel().length() - suffixLength);
            }
        }
        String labelWithIndex = label;
        int value = instanceCounter.containsKey(mygenusname) ? instanceCounter.get(mygenusname) : 0;
        while (!BlockUtilities.isLabelValid(myblock, labelWithIndex)) {
            labelWithIndex = labelWithIndex + ++value;
        }
        instanceCounter.put(mygenusname, new Integer(value));
        if (!labelWithIndex.equals(label)) {
            label = labelWithIndex;
        }
        if (myblock instanceof BlockStub) {
            Block parent = ((BlockStub)myblock).getParent();
            block = new BlockStub(workspace, parent.getBlockID(), parent.getGenusName(), parent.getBlockLabel(), myblock.getGenusName());
        } else {
            block = new Block(workspace, myblock.getGenusName(), label);
        }
        RenderableBlock renderable = new RenderableBlock(workspace, null, block.getBlockID());
        renderable.setZoomLevel(zoom);
        renderable.redrawFromTop();
        renderable.repaint();
        return renderable;
    }

    public static String disambiguousStringRep(RenderableBlock block) {
        String rep = block.getKeyword();
        String genus = block.getGenus();
        Iterator<BlockConnector> sockets = block.getBlock().getSockets().iterator();
        if (sockets.hasNext()) {
            String socketLabels = " [";
            while (sockets.hasNext()) {
                if (socketLabels.length() > 2) {
                    socketLabels = socketLabels + ", ";
                }
                socketLabels = socketLabels + sockets.next().getLabel();
            }
            socketLabels = socketLabels + "]";
            if (genus.equals("sum")) {
                return rep + " [number]";
            }
            if (genus.equals("string-append")) {
                return rep + " [text]";
            }
            return rep + socketLabels;
        }
        return rep;
    }

    public static List<TextualFactoryBlock> getAllMatchingBlocks(Workspace workspace, String keyword) {
        TreeSet<TextualFactoryBlock> matchingBlocks = new TreeSet<TextualFactoryBlock>(new MatchingComparator(keyword));
        for (RenderableBlock renderable : workspace.getFactoryManager().getBlocks()) {
            if (renderable == null || renderable.getBlockID().equals(Block.NULL) || !(renderable instanceof FactoryRenderableBlock)) continue;
            if (renderable.getKeyword().toLowerCase().contains(keyword.toLowerCase())) {
                matchingBlocks.add(new TextualFactoryBlock((FactoryRenderableBlock)renderable, renderable.getBlock().getBlockLabel()));
            }
            if (keyword.startsWith("\"") && renderable.getBlock().getGenusName().equalsIgnoreCase("string")) {
                String[] quote = keyword.split("\"");
                if (quote.length <= 1) continue;
                matchingBlocks.add(new TextualFactoryBlock((FactoryRenderableBlock)renderable, "\"" + quote[1] + "\""));
                continue;
            }
            if (keyword.length() <= renderable.getKeyword().length() || !BlockUtilities.disambiguousStringRep((FactoryRenderableBlock)renderable).toLowerCase().contains(keyword.toLowerCase())) continue;
            matchingBlocks.add(new TextualFactoryBlock((FactoryRenderableBlock)renderable, BlockUtilities.disambiguousStringRep((FactoryRenderableBlock)renderable)));
        }
        ArrayList<TextualFactoryBlock> disambiguatedMatches = new ArrayList<TextualFactoryBlock>(matchingBlocks);
        for (int i = 0; i < disambiguatedMatches.size(); ++i) {
            TextualFactoryBlock t2;
            TextualFactoryBlock t1 = disambiguatedMatches.get(i);
            if (i > 0) {
                t2 = disambiguatedMatches.get(i - 1);
                if (t1.toString().equals(t2.toString())) {
                    disambiguatedMatches.set(i, new TextualFactoryBlock(t1.getfactoryBlock(), BlockUtilities.disambiguousStringRep(t1.getfactoryBlock())));
                    disambiguatedMatches.set(i - 1, new TextualFactoryBlock(t2.getfactoryBlock(), BlockUtilities.disambiguousStringRep(t2.getfactoryBlock())));
                }
            }
            if (i >= disambiguatedMatches.size() - 1) continue;
            t2 = disambiguatedMatches.get(i + 1);
            if (!t1.toString().equals(t2.toString())) continue;
            disambiguatedMatches.set(i, new TextualFactoryBlock(t1.getfactoryBlock(), BlockUtilities.disambiguousStringRep(t1.getfactoryBlock())));
            disambiguatedMatches.set(i + 1, new TextualFactoryBlock(t2.getfactoryBlock(), BlockUtilities.disambiguousStringRep(t2.getfactoryBlock())));
        }
        return disambiguatedMatches;
    }

    public static List<TextualFactoryBlock> getPlusBlocks(Workspace workspace, String plus) {
        HashSet<TextualFactoryBlock> matchingBlocks = new HashSet<TextualFactoryBlock>();
        for (RenderableBlock renderable : workspace.getFactoryManager().getBlocks()) {
            if (renderable == null || renderable.getBlockID().equals(Block.NULL) || !(renderable instanceof FactoryRenderableBlock)) continue;
            if (renderable.getBlock().getGenusName().equalsIgnoreCase("sum")) {
                matchingBlocks.add(new TextualFactoryBlock((FactoryRenderableBlock)renderable, "+ [number]"));
            }
            if (renderable.getBlock().getGenusName().equalsIgnoreCase("string-append")) {
                matchingBlocks.add(new TextualFactoryBlock((FactoryRenderableBlock)renderable, "+ [text]"));
            }
            if (!renderable.getKeyword().toLowerCase().contains(plus.toLowerCase())) continue;
            matchingBlocks.add(new TextualFactoryBlock((FactoryRenderableBlock)renderable, renderable.getBlock().getBlockLabel()));
        }
        return new ArrayList<TextualFactoryBlock>(matchingBlocks);
    }

    public static List<TextualFactoryBlock> getDigits(Workspace workspace, String digits) {
        TreeSet<TextualFactoryBlock> matchingBlocks = new TreeSet<TextualFactoryBlock>(new MatchingComparator(digits));
        for (RenderableBlock renderable : workspace.getFactoryManager().getBlocks()) {
            if (renderable == null || renderable.getBlockID().equals(Block.NULL) || !(renderable instanceof FactoryRenderableBlock)) continue;
            if (renderable.getBlock().getGenusName().equalsIgnoreCase("number")) {
                matchingBlocks.add(new TextualFactoryBlock((FactoryRenderableBlock)renderable, digits));
            }
            if (!renderable.getKeyword().toLowerCase().contains(digits.toLowerCase())) continue;
            matchingBlocks.add(new TextualFactoryBlock((FactoryRenderableBlock)renderable, renderable.getBlock().getBlockLabel()));
        }
        return new ArrayList<TextualFactoryBlock>(matchingBlocks);
    }

    public static RenderableBlock getBlock(Workspace workspace, String genusName, String label) {
        if (genusName == null) {
            return null;
        }
        for (Block block : workspace.getBlocks()) {
            if (block == null || block.getBlockID() == null || block.getBlockID().equals(Block.NULL) || !block.getGenusName().equals(genusName) || !block.isLabelEditable() && !block.getBlockLabel().equals(label) && !block.isInfix() || block instanceof BlockStub && !block.getBlockLabel().equals(label)) continue;
            RenderableBlock renderable = BlockUtilities.cloneBlock(block);
            if (renderable == null || renderable.getBlockID().equals(Block.NULL)) {
                throw new RuntimeException("Invariant Violated: a valid non null blockID justreturned a null instance of RenderableBlock");
            }
            renderable.ignoreDefaultArguments();
            Block newblock = workspace.getEnv().getBlock(renderable.getBlockID());
            if (newblock == null || newblock.getBlockID().equals(Block.NULL)) {
                throw new RuntimeException("Invariant Violated: a valid non null blockID justreturned a null instance of Block");
            }
            if ((block.isLabelEditable() || block.getBlockLabel().equals(label)) && label != null && !(block instanceof BlockStub) && newblock.isLabelEditable() && !newblock.labelMustBeUnique()) {
                newblock.setBlockLabel(label);
            }
            return renderable;
        }
        return null;
    }

    private static boolean isNullBlockInstance(Workspace workspace, Long blockID) {
        if (blockID == null) {
            return true;
        }
        if (blockID.equals(Block.NULL)) {
            return true;
        }
        if (workspace.getEnv().getBlock(blockID) == null) {
            return true;
        }
        if (workspace.getEnv().getBlock(blockID).getBlockID() == null) {
            return true;
        }
        if (workspace.getEnv().getBlock(blockID).getBlockID().equals(Block.NULL)) {
            return true;
        }
        if (workspace.getEnv().getRenderableBlock(blockID) == null) {
            return true;
        }
        if (workspace.getEnv().getRenderableBlock(blockID).getBlockID() == null) {
            return true;
        }
        return workspace.getEnv().getRenderableBlock(blockID).getBlockID().equals(Block.NULL);
    }

    public static BlockNode makeNodeWithChildren(Workspace workspace, Long blockID) {
        if (BlockUtilities.isNullBlockInstance(workspace, blockID)) {
            return null;
        }
        Block block = workspace.getEnv().getBlock(blockID);
        String genus = block.getGenusName();
        String parentGenus = block instanceof BlockStub ? ((BlockStub)block).getParentGenus() : null;
        String label = !block.labelMustBeUnique() || block instanceof BlockStub ? block.getBlockLabel() : null;
        BlockNode node = new BlockNode(genus, parentGenus, label);
        for (BlockConnector socket : block.getSockets()) {
            if (!socket.hasBlock()) continue;
            node.addChild(BlockUtilities.makeNodeWithStack(workspace, socket.getBlockID()));
        }
        return node;
    }

    public static BlockNode makeNodeWithStack(Workspace workspace, Long blockID) {
        if (BlockUtilities.isNullBlockInstance(workspace, blockID)) {
            return null;
        }
        Block block = workspace.getEnv().getBlock(blockID);
        String genus = block.getGenusName();
        String parentGenus = block instanceof BlockStub ? ((BlockStub)block).getParentGenus() : null;
        String label = !block.labelMustBeUnique() || block instanceof BlockStub ? block.getBlockLabel() : null;
        BlockNode node = new BlockNode(genus, parentGenus, label);
        for (BlockConnector socket : block.getSockets()) {
            if (!socket.hasBlock()) continue;
            node.addChild(BlockUtilities.makeNodeWithStack(workspace, socket.getBlockID()));
        }
        if (block.hasAfterConnector()) {
            node.setAfter(BlockUtilities.makeNodeWithStack(workspace, block.getAfterBlockID()));
        }
        return node;
    }

    public static boolean blockExists(Workspace workspace, BlockNode node) {
        String genusName = node.getGenusName();
        RenderableBlock renderable = BlockUtilities.getBlock(workspace, genusName, node.getLabel());
        return renderable != null;
    }

    public static RenderableBlock makeRenderable(Workspace workspace, BlockNode node, WorkspaceWidget widget) {
        String genusName = node.getGenusName();
        RenderableBlock renderable = BlockUtilities.getBlock(workspace, genusName, node.getLabel());
        if (renderable == null) {
            throw new RuntimeException("No children block exists for this genus: " + genusName);
        }
        Block block = workspace.getEnv().getBlock(renderable.getBlockID());
        widget.blockDropped(renderable);
        for (int i = 0; i < node.getChildren().size(); ++i) {
            BlockConnector socket = block.getSocketAt(i);
            BlockNode child = node.getChildren().get(i);
            RenderableBlock childRenderable = BlockUtilities.makeRenderable(workspace, child, widget);
            Block childBlock = workspace.getEnv().getBlock(childRenderable.getBlockID());
            BlockLink link = childBlock.hasPlug() ? BlockLinkChecker.canLink(workspace, block, childBlock, socket, childBlock.getPlug()) : (childBlock.hasBeforeConnector() ? BlockLinkChecker.canLink(workspace, block, childBlock, socket, childBlock.getBeforeConnector()) : null);
            link.connect();
            workspace.notifyListeners(new WorkspaceEvent(workspace, workspace.getEnv().getRenderableBlock(link.getPlugBlockID()).getParentWidget(), link, 5));
        }
        if (node.getAfterNode() != null) {
            BlockConnector socket = block.getAfterConnector();
            BlockNode child = node.getAfterNode();
            RenderableBlock childRenderable = BlockUtilities.makeRenderable(workspace, child, widget);
            Block childBlock = workspace.getEnv().getBlock(childRenderable.getBlockID());
            BlockLink link = childBlock.hasPlug() ? BlockLinkChecker.canLink(workspace, block, childBlock, socket, childBlock.getPlug()) : (childBlock.hasBeforeConnector() ? BlockLinkChecker.canLink(workspace, block, childBlock, socket, childBlock.getBeforeConnector()) : null);
            link.connect();
            workspace.notifyListeners(new WorkspaceEvent(workspace, workspace.getEnv().getRenderableBlock(link.getPlugBlockID()).getParentWidget(), link, 5));
        }
        return renderable;
    }

    private static class MatchingComparator
    implements Comparator<TextualFactoryBlock> {
        private String keyword;

        public MatchingComparator(String keyword) {
            this.keyword = keyword.toLowerCase();
        }

        @Override
        public int compare(TextualFactoryBlock t1, TextualFactoryBlock t2) {
            if (t1.compareTo(t2) == 0) {
                return 0;
            }
            if (t1.toString().toLowerCase().indexOf(this.keyword) == t2.toString().toLowerCase().indexOf(this.keyword)) {
                return t1.compareTo(t2);
            }
            return t1.toString().toLowerCase().indexOf(this.keyword) > t2.toString().toLowerCase().indexOf(this.keyword) ? 1 : -1;
        }
    }
}

