/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.controller;

import edu.mit.blocks.codeblocks.BlockConnectorShape;
import edu.mit.blocks.codeblocks.BlockGenus;
import edu.mit.blocks.codeblocks.BlockLinkChecker;
import edu.mit.blocks.codeblocks.CommandRule;
import edu.mit.blocks.codeblocks.SocketRule;
import edu.mit.blocks.workspace.SearchBar;
import edu.mit.blocks.workspace.SearchableContainer;
import edu.mit.blocks.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WorkspaceController {
    private Element langDefRoot;
    private boolean isWorkspacePanelInitialized = false;
    protected JPanel workspacePanel;
    protected final Workspace workspace = new Workspace();
    protected SearchBar searchBar;
    private boolean langDefDirty = true;
    private InputStream langDefDtd;
    private boolean workspaceLoaded = false;
    private File lastDirectory;
    private File selectedFile;
    private JFrame frame;
    private ResourceBundle langResourceBundle;
    private List<String[]> styleList;

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setLangDefDtd(InputStream is) {
        this.langDefDtd = is;
    }

    public void setLangResourceBundle(ResourceBundle bundle) {
        this.langResourceBundle = bundle;
    }

    public void setStyleList(List<String[]> list) {
        this.styleList = list;
    }

    public void setLangDefFilePath(String filePath) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            this.setLangDefStream(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void setLangDefStream(InputStream in) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (this.langDefDtd != null) {
                builder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(WorkspaceController.this.langDefDtd);
                    }
                });
            }
            Document doc = builder.parse(in);
            this.ardublockLocalize(doc);
            this.ardublockStyling(doc);
            this.langDefRoot = doc.getDocumentElement();
            this.langDefDirty = true;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void ardublockStyling(Document doc) {
        if (this.styleList != null) {
            XPathFactory factory = XPathFactory.newInstance();
            for (String[] style : this.styleList) {
                XPath xpath = factory.newXPath();
                try {
                    XPathExpression expr = xpath.compile(style[0]);
                    NodeList bgs = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                    for (int i = 0; i < bgs.getLength(); ++i) {
                        Node bg = bgs.item(i);
                        bg.setNodeValue(style[1]);
                    }
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void ardublockLocalize(Document doc) {
        if (this.langResourceBundle != null) {
            String altName;
            String name;
            Element elm;
            int i;
            NodeList nodes = doc.getElementsByTagName("BlockGenus");
            for (i = 0; i < nodes.getLength(); ++i) {
                NodeList texts;
                Element text;
                NodeList descriptions;
                Element description;
                elm = (Element)nodes.item(i);
                name = elm.getAttribute("name");
                altName = this.langResourceBundle.getString("bg." + name);
                if (altName != null) {
                    elm.setAttribute("initlabel", altName);
                }
                if ((description = (Element)(descriptions = elm.getElementsByTagName("description")).item(0)) != null && (text = (Element)(texts = description.getElementsByTagName("text")).item(0)) != null && (altName = this.langResourceBundle.getString("bg." + name + ".description")) != null) {
                    text.setTextContent(altName);
                }
                NodeList arg_descs = elm.getElementsByTagName("arg-description");
                for (int j = 0; j < arg_descs.getLength(); ++j) {
                    Element arg_desc = (Element)arg_descs.item(j);
                    String arg_name = arg_desc.getAttribute("name");
                }
            }
            nodes = doc.getElementsByTagName("BlockDrawer");
            for (i = 0; i < nodes.getLength(); ++i) {
                elm = (Element)nodes.item(i);
                name = elm.getAttribute("name");
                altName = this.langResourceBundle.getString(name);
                if (altName == null) continue;
                elm.setAttribute("name", altName);
            }
            nodes = doc.getElementsByTagName("BlockConnector");
            for (i = 0; i < nodes.getLength(); ++i) {
                elm = (Element)nodes.item(i);
                name = elm.getAttribute("label");
                if (!name.startsWith("bc.") || (altName = this.langResourceBundle.getString(name)) == null) continue;
                elm.setAttribute("label", altName);
            }
        }
    }

    public void loadBlockLanguage(Element root) {
        BlockConnectorShape.loadBlockConnectorShapes(root);
        BlockGenus.loadBlockGenera(this.workspace, root);
        BlockLinkChecker.addRule(this.workspace, new CommandRule(this.workspace));
        BlockLinkChecker.addRule(this.workspace, new SocketRule());
        this.langDefDirty = false;
    }

    public void resetLanguage() {
        BlockConnectorShape.resetConnectorShapeMappings();
        this.getWorkspace().getEnv().resetAllGenuses();
        BlockLinkChecker.reset();
    }

    public String getSaveString() {
        try {
            Node node = this.getSaveNode();
            StringWriter writer = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public Node getSaveNode() {
        return this.getSaveNode(true);
    }

    public Node getSaveNode(boolean validate) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element documentElement = document.createElementNS("http://education.mit.edu/openblocks/ns", "cb:CODEBLOCKS");
            documentElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://education.mit.edu/openblocks/ns http://education.mit.edu/openblocks/codeblocks.xsd");
            Node workspaceNode = this.workspace.getSaveNode(document);
            if (workspaceNode != null) {
                documentElement.appendChild(workspaceNode);
            }
            document.appendChild(documentElement);
            if (validate) {
                this.validate(document);
            }
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void validate(Document document) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaUrl = this.getClass().getResource("/edu/mit/blocks/codeblocks/codeblocks.xsd");
            Schema schema = schemaFactory.newSchema(schemaUrl);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(document));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadFreshWorkspace() {
        if (this.workspaceLoaded) {
            this.resetWorkspace();
        }
        if (this.langDefDirty) {
            this.loadBlockLanguage(this.langDefRoot);
        }
        this.workspace.loadWorkspaceFrom(null, this.langDefRoot);
        this.workspaceLoaded = true;
    }

    public void loadProjectFromPath(String path) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(path));
            Element projectRoot = doc.getDocumentElement();
            this.workspace.loadWorkspaceFrom(projectRoot, this.langDefRoot);
            this.workspaceLoaded = true;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadProjectFromElement(Element elementToLoad) {
        this.workspace.loadWorkspaceFrom(elementToLoad, this.langDefRoot);
        this.workspaceLoaded = true;
    }

    public void loadProject(String projectContents, String langDefContents) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document projectDoc = builder.parse(new InputSource(new StringReader(projectContents)));
            Element projectRoot = projectDoc.getDocumentElement();
            Document langDoc = builder.parse(new InputSource(new StringReader(projectContents)));
            Element langRoot = langDoc.getDocumentElement();
            if (this.workspaceLoaded) {
                this.resetWorkspace();
            }
            if (langDefContents == null) {
                this.loadBlockLanguage(this.langDefRoot);
            } else {
                this.loadBlockLanguage(langRoot);
            }
            this.workspace.loadWorkspaceFrom(projectRoot, langRoot);
            this.workspaceLoaded = true;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void resetWorkspace() {
        this.workspace.reset();
    }

    private void initWorkspacePanel() {
        this.workspacePanel = new JPanel();
        this.workspacePanel.setLayout(new BorderLayout());
        this.workspacePanel.add((Component)this.workspace, "Center");
        this.isWorkspacePanelInitialized = true;
    }

    public JComponent getWorkspacePanel() {
        if (!this.isWorkspacePanelInitialized) {
            this.initWorkspacePanel();
        }
        return this.workspacePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(File file) throws IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(this.getSaveString());
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public void setSelectedFile(File selectedFile) {
        this.selectedFile = selectedFile;
        this.frame.setTitle("WorkspaceDemo - " + selectedFile.getPath());
    }

    private JComponent getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        OpenAction openAction = new OpenAction();
        buttonPanel.add(new JButton(openAction));
        SaveAction saveAction = new SaveAction();
        buttonPanel.add(new JButton(saveAction));
        SaveAsAction saveAsAction = new SaveAsAction(saveAction);
        buttonPanel.add(new JButton(saveAsAction));
        return buttonPanel;
    }

    public JComponent getSearchBar() {
        SearchBar sb = new SearchBar("Search blocks", "Search for blocks in the drawers and workspace", this.workspace);
        for (SearchableContainer con : this.getAllSearchableContainers()) {
            sb.addSearchableContainer(con);
        }
        return sb.getComponent();
    }

    public Iterable<SearchableContainer> getAllSearchableContainers() {
        return this.workspace.getAllSearchableContainers();
    }

    private void createAndShowGUI() {
        this.frame = new JFrame("WorkspaceDemo");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setBounds(100, 100, 800, 600);
        SearchBar sb = new SearchBar("Search blocks", "Search for blocks in the drawers and workspace", this.workspace);
        for (SearchableContainer con : this.getAllSearchableContainers()) {
            sb.addSearchableContainer(con);
        }
        JPanel topPane = new JPanel();
        sb.getComponent().setPreferredSize(new Dimension(130, 23));
        topPane.add(sb.getComponent());
        this.frame.add((Component)topPane, "First");
        this.frame.add((Component)this.getWorkspacePanel(), "Center");
        this.frame.add((Component)this.getButtonPanel(), "South");
        this.frame.setVisible(true);
    }

    public static void main(final String[] args) {
        if (args.length < 1) {
            System.err.println("usage: WorkspaceController lang_def.xml");
            System.exit(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkspaceController wc = new WorkspaceController();
                wc.setLangDefFilePath(args[0]);
                wc.loadFreshWorkspace();
                wc.createAndShowGUI();
            }
        });
    }

    private class SaveAsAction
    extends AbstractAction {
        private static final long serialVersionUID = 3981294764824307472L;
        private final SaveAction saveAction;

        SaveAsAction(SaveAction saveAction) {
            super("Save As...");
            this.saveAction = saveAction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceController.this.selectedFile = null;
            this.saveAction.actionPerformed(e);
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = -5540588250535739852L;

        SaveAction() {
            super("Save");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fileChooser;
            if (WorkspaceController.this.selectedFile == null && (fileChooser = new JFileChooser(WorkspaceController.this.lastDirectory)).showSaveDialog((Component)evt.getSource()) == 0) {
                WorkspaceController.this.setSelectedFile(fileChooser.getSelectedFile());
                WorkspaceController.this.lastDirectory = WorkspaceController.this.selectedFile.getParentFile();
            }
            try {
                WorkspaceController.this.saveToFile(WorkspaceController.this.selectedFile);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog((Component)evt.getSource(), e.getMessage());
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = -2119679269613495704L;

        OpenAction() {
            super("Open");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(WorkspaceController.this.lastDirectory);
            if (fileChooser.showOpenDialog((Component)e.getSource()) == 0) {
                WorkspaceController.this.setSelectedFile(fileChooser.getSelectedFile());
                WorkspaceController.this.lastDirectory = WorkspaceController.this.selectedFile.getParentFile();
                String selectedPath = WorkspaceController.this.selectedFile.getPath();
                WorkspaceController.this.loadFreshWorkspace();
                try {
                    WorkspaceController.this.loadProjectFromPath(selectedPath);
                }
                catch (IOException ee) {
                    throw new RuntimeException(ee);
                }
            }
        }
    }
}

