/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CArrowButton;
import edu.mit.blocks.codeblockutil.CGraphite;
import edu.mit.blocks.codeblockutil.CHoverScrollPane;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.CTracklessScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CWheeler
extends JPanel {
    static final long serialVersionUID = 82391823L;
    static final Color background = new Color(50, 50, 50);
    Collection<? extends JComponent> elements;
    CScrollPane scroll;
    JComponent view;

    public CWheeler(boolean includeScrollbar) {
        this(new ArrayList<JComponent>(), includeScrollbar, background);
    }

    public CWheeler(Collection<JComponent> items) {
        this(items, true, background);
    }

    public CWheeler(Collection<JComponent> items, boolean includeScrollbar, Color backgroundColor) {
        super(new BorderLayout());
        this.setBackground(backgroundColor);
        this.elements = items;
        if (includeScrollbar) {
            CArrowButton left = new CArrowButton(CArrowButton.Direction.WEST){
                private static final long serialVersionUID = 328149080242L;

                @Override
                public void triggerAction() {
                    CWheeler.this.scrollLeft();
                }
            };
            left.addActionListener(left);
            left.setPreferredSize(new Dimension(15, 15));
            CArrowButton cArrowButton = new CArrowButton(CArrowButton.Direction.EAST){
                private static final long serialVersionUID = 328149080243L;

                @Override
                public void triggerAction() {
                    CWheeler.this.scrollRight();
                }
            };
            cArrowButton.addActionListener(cArrowButton);
            cArrowButton.setPreferredSize(new Dimension(15, 15));
            this.view = new JPanel(null);
            this.view.setBackground(backgroundColor);
            this.scroll = new CHoverScrollPane(this.view, CScrollPane.ScrollPolicy.VERTICAL_BAR_NEVER, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_ALWAYS, 20, CGraphite.blue, new Color(0, 0, 50));
            JPanel leftPane = new JPanel(new BorderLayout());
            leftPane.setBackground(backgroundColor);
            leftPane.add((Component)left, "South");
            this.add((Component)leftPane, "West");
            JPanel rightPane = new JPanel(new BorderLayout());
            rightPane.setBackground(backgroundColor);
            rightPane.add((Component)cArrowButton, "South");
            this.add((Component)rightPane, "East");
        } else {
            this.view = new JPanel(null);
            this.view.setBackground(backgroundColor);
            this.scroll = new CTracklessScrollPane(this.view, CScrollPane.ScrollPolicy.VERTICAL_BAR_NEVER, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_NEVER, 20, Color.blue, new Color(0, 0, 50));
        }
        for (JComponent jComponent : this.elements) {
            this.view.add(jComponent);
        }
        this.add((Component)this.scroll, "Center");
        this.reformItems();
    }

    public void scrollLeft() {
        int v = this.scroll.getHorizontalModel().getValue();
        int accumulatedWidth = 0;
        for (JComponent jComponent : this.elements) {
            if ((accumulatedWidth += jComponent.getWidth()) < v) continue;
            accumulatedWidth -= jComponent.getWidth();
            break;
        }
        this.scroll.getHorizontalModel().setValue(accumulatedWidth);
        this.scroll.revalidate();
        this.scroll.repaint();
    }

    public void scrollRight() {
        int v = this.scroll.getHorizontalModel().getValue();
        int accumulatedWidth = 0;
        for (JComponent jComponent : this.elements) {
            if ((accumulatedWidth += jComponent.getWidth()) > v) break;
        }
        this.scroll.getHorizontalModel().setValue(accumulatedWidth);
        this.scroll.revalidate();
        this.scroll.repaint();
    }

    private void reformItems() {
        int totalWidth = 0;
        int maxHeight = 0;
        for (JComponent jComponent : this.elements) {
            jComponent.setBounds(totalWidth, 0, jComponent.getPreferredSize().width, jComponent.getPreferredSize().height);
            totalWidth += jComponent.getPreferredSize().width;
            maxHeight = Math.max(maxHeight, jComponent.getPreferredSize().height);
        }
        this.view.setPreferredSize(new Dimension(totalWidth, maxHeight));
        this.view.setBounds(0, 0, totalWidth, maxHeight);
        this.revalidate();
        this.repaint();
    }

    public void setElements(Collection<? extends JComponent> items) {
        this.elements = items;
        this.view.removeAll();
        for (JComponent jComponent : items) {
            this.view.add(jComponent);
        }
        this.reformItems();
    }

    public void scrollToWheelItem(JComponent item) {
        this.scroll.validate();
        this.scroll.getHorizontalModel().setValue(item.getX());
    }
}

