/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.workspace.ISupportMemento;
import edu.mit.blocks.workspace.Workspace;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BlockConnector
implements ISupportMemento {
    private String kind;
    private String initKind;
    private PositionType positionType;
    private String label;
    private Long connBlockID = Block.NULL;
    private DefArgument arg = null;
    private boolean hasDefArg = false;
    private boolean isExpandable = false;
    private boolean isLabelEditable = false;
    private String expandGroup = "";
    private final Workspace workspace;

    public BlockConnector(Workspace workspace, String kind, PositionType positionType, String label, boolean isLabelEditable, boolean isExpandable, String expandGroup, Long connBlockID) {
        this(workspace, kind, positionType, label, isLabelEditable, isExpandable, connBlockID);
        this.expandGroup = expandGroup == null ? "" : expandGroup;
    }

    public BlockConnector(Workspace workspace, String kind, PositionType positionType, String label, boolean isLabelEditable, boolean isExpandable, Long connBlockID) {
        this.workspace = workspace;
        this.kind = kind;
        this.positionType = positionType;
        this.label = label;
        this.isLabelEditable = isLabelEditable;
        this.connBlockID = connBlockID;
        this.isExpandable = isExpandable;
        this.initKind = kind;
    }

    public BlockConnector(Workspace workspace, String kind, String label, Long socketBlockID) {
        this(workspace, kind, PositionType.SINGLE, label, false, false, socketBlockID);
    }

    public BlockConnector(Workspace workspace, String label, String kind, boolean isLabelEditable, boolean isExpandable) {
        this(workspace, kind, PositionType.SINGLE, label, isLabelEditable, isExpandable, Block.NULL);
    }

    public BlockConnector(BlockConnector con) {
        this(con.workspace, con.kind, con.positionType, con.label, con.isLabelEditable, con.isExpandable, con.connBlockID);
        this.hasDefArg = con.hasDefArg;
        this.arg = con.arg;
        this.isLabelEditable = con.isLabelEditable;
        this.expandGroup = con.expandGroup;
    }

    public String getLabel() {
        return this.label;
    }

    public String getKind() {
        return this.kind;
    }

    public String initKind() {
        return this.initKind;
    }

    public PositionType getPositionType() {
        return this.positionType;
    }

    public Long getBlockID() {
        return this.connBlockID;
    }

    public boolean hasBlock() {
        return !this.connBlockID.equals(Block.NULL);
    }

    public boolean isExpandable() {
        return this.isExpandable;
    }

    public String getExpandGroup() {
        return this.expandGroup;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isLabelEditable() {
        return this.isLabelEditable;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setConnectorBlockID(Long id) {
        this.connBlockID = id;
    }

    public void setPositionType(PositionType pos) {
        this.positionType = pos;
    }

    public boolean hasDefArg() {
        return this.hasDefArg;
    }

    public void setDefaultArgument(String genusName, String label) {
        this.hasDefArg = true;
        this.arg = new DefArgument(genusName, label);
    }

    public Long linkDefArgument() {
        if (this.hasDefArg && this.connBlockID == Block.NULL) {
            Block block = new Block(this.workspace, this.arg.getGenusName(), this.arg.label);
            this.connBlockID = block.getBlockID();
            return this.connBlockID;
        }
        return Block.NULL;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Connector label: ");
        out.append(this.label);
        out.append(", Connector kind: ");
        out.append(this.kind);
        out.append(", blockID: ");
        out.append(this.connBlockID);
        out.append(" with pos type: ");
        out.append((Object)this.getPositionType());
        return out.toString();
    }

    public static BlockConnector loadBlockConnector(Workspace workspace, Node node, HashMap<Long, Long> idMapping) {
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        BlockConnector con = null;
        String initKind = null;
        String kind = null;
        Long idConnected = Block.NULL;
        String label = "";
        boolean isExpandable = false;
        boolean isLabelEditable = false;
        String expandGroup = "";
        String positionType = "single";
        if (node.getNodeName().equals("BlockConnector")) {
            Node opt_item;
            Matcher nameMatcher = attrExtractor.matcher(node.getAttributes().getNamedItem("init-type").toString());
            if (nameMatcher.find()) {
                initKind = nameMatcher.group(1);
            }
            if ((nameMatcher = attrExtractor.matcher(node.getAttributes().getNamedItem("connector-type").toString())).find()) {
                kind = nameMatcher.group(1);
            }
            if ((nameMatcher = attrExtractor.matcher(node.getAttributes().getNamedItem("label").toString())).find()) {
                label = nameMatcher.group(1);
            }
            if ((opt_item = node.getAttributes().getNamedItem("con-block-id")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                idConnected = Block.translateLong(workspace, Long.parseLong(nameMatcher.group(1)), idMapping);
            }
            if ((opt_item = node.getAttributes().getNamedItem("label-editable")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                isLabelEditable = nameMatcher.group(1).equals("true");
            }
            if ((opt_item = node.getAttributes().getNamedItem("is-expandable")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                boolean bl = isExpandable = nameMatcher.group(1).equals("yes");
            }
            if ((opt_item = node.getAttributes().getNamedItem("expand-group")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                expandGroup = nameMatcher.group(1);
            }
            if ((opt_item = node.getAttributes().getNamedItem("position-type")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                positionType = nameMatcher.group(1);
            }
            assert (initKind != null) : "BlockConnector was not specified a initial connection kind";
            if (positionType.equals("single")) {
                con = new BlockConnector(workspace, initKind, PositionType.SINGLE, label, isLabelEditable, isExpandable, idConnected);
            } else if (positionType.equals("bottom")) {
                con = new BlockConnector(workspace, initKind, PositionType.BOTTOM, label, isLabelEditable, isExpandable, idConnected);
            } else if (positionType.equals("mirror")) {
                con = new BlockConnector(workspace, initKind, PositionType.MIRROR, label, isLabelEditable, isExpandable, idConnected);
            } else if (positionType.endsWith("top")) {
                con = new BlockConnector(workspace, initKind, PositionType.TOP, label, isLabelEditable, isExpandable, idConnected);
            }
            con.expandGroup = expandGroup;
            if (!initKind.equals(kind)) {
                con.setKind(kind);
            }
        }
        assert (con != null) : "BlockConnector was not loaded " + node;
        return con;
    }

    public Node getSaveNode(Document document, String conKind) {
        Element connectorElement = document.createElement("BlockConnector");
        connectorElement.setAttribute("connector-kind", conKind);
        connectorElement.setAttribute("connector-type", this.kind);
        connectorElement.setAttribute("init-type", this.initKind);
        connectorElement.setAttribute("label", this.label);
        if (this.expandGroup.length() > 0) {
            connectorElement.setAttribute("expand-group", this.expandGroup);
        }
        if (this.isExpandable) {
            connectorElement.setAttribute("is-expandable", "yes");
        }
        if (this.positionType.equals((Object)PositionType.SINGLE)) {
            connectorElement.setAttribute("position-type", "single");
        } else if (this.positionType.equals((Object)PositionType.MIRROR)) {
            connectorElement.setAttribute("position-type", "mirror");
        } else if (this.positionType.equals((Object)PositionType.BOTTOM)) {
            connectorElement.setAttribute("position-type", "bottom");
        } else if (this.positionType.equals((Object)PositionType.TOP)) {
            connectorElement.setAttribute("position-type", "top");
        }
        if (this.isLabelEditable) {
            connectorElement.setAttribute("label-editable", "true");
        }
        if (!this.connBlockID.equals(Block.NULL)) {
            connectorElement.setAttribute("con-block-id", Long.toString(this.connBlockID));
        }
        return connectorElement;
    }

    @Override
    public Object getState() {
        BlockConnectorState state = new BlockConnectorState();
        state.kind = this.getKind();
        state.positionType = this.getPositionType();
        state.label = this.getLabel();
        state.connBlockID = this.getBlockID();
        if (this.hasDefArg()) {
            state.defArgGenusName = this.arg.getGenusName();
            state.defArgLabel = this.arg.getLabel();
            state.hasDefArg = true;
        } else {
            state.defArgGenusName = null;
            state.defArgLabel = null;
            state.hasDefArg = false;
        }
        state.isExpandable = this.isExpandable();
        state.isLabelEditable = this.isLabelEditable;
        state.expandGroup = this.expandGroup;
        return state;
    }

    @Override
    public void loadState(Object memento) {
        if (memento instanceof BlockConnectorState) {
            BlockConnectorState state = (BlockConnectorState)memento;
            this.setKind(state.kind);
            this.setPositionType(state.positionType);
            this.setLabel(state.label);
            this.setConnectorBlockID(state.connBlockID);
            if (state.hasDefArg) {
                this.setDefaultArgument(state.defArgGenusName, state.defArgLabel);
            } else {
                this.arg = null;
            }
            this.isExpandable = state.isExpandable;
            this.isLabelEditable = state.isLabelEditable;
            this.expandGroup = state.expandGroup;
        }
    }

    public static BlockConnector instantiateFromState(Workspace workspace, Object memento) {
        if (memento instanceof BlockConnectorState) {
            BlockConnectorState state = (BlockConnectorState)memento;
            BlockConnector instance = new BlockConnector(workspace, state.kind, state.positionType, state.label, state.isLabelEditable, state.isExpandable, state.connBlockID);
            instance.isLabelEditable = state.isLabelEditable;
            if (state.hasDefArg) {
                instance.setDefaultArgument(state.defArgGenusName, state.defArgLabel);
            }
            return instance;
        }
        return null;
    }

    private class BlockConnectorState {
        public String kind;
        public PositionType positionType;
        public String label;
        public Long connBlockID = Block.NULL;
        public boolean hasDefArg;
        public String defArgGenusName;
        public String defArgLabel;
        public boolean isExpandable;
        public String expandGroup;
        public boolean isLabelEditable;

        private BlockConnectorState() {
        }
    }

    private class DefArgument {
        private String genusName;
        private String label;

        public DefArgument(String genusName, String label) {
            this.genusName = genusName;
            this.label = label;
        }

        public String getGenusName() {
            return this.genusName;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum PositionType {
        SINGLE,
        MIRROR,
        BOTTOM,
        TOP;

    }
}

