/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator;

import com.ardublock.translator.adaptor.BlockAdaptor;
import com.ardublock.translator.adaptor.OpenBlocksAdaptor;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.TranslatorBlockFactory;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNameDuplicatedException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;
import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.workspace.Workspace;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Translator {
    private static final String variablePrefix = "_ABVAR_";
    private Set<String> headerFileSet;
    private Set<String> definitionSet;
    private List<String> setupCommand;
    private Set<String> functionNameSet;
    private Set<TranslatorBlock> bodyTranslatreFinishCallbackSet;
    private BlockAdaptor blockAdaptor;
    private Set<Long> inputPinSet;
    private Set<Long> outputPinSet;
    private Map<String, String> numberVariableSet;
    private Map<String, String> booleanVariableSet;
    private Workspace workspace;
    private int variableCnt;

    public Translator(Workspace ws) {
        this.workspace = ws;
        this.reset();
    }

    public String genreateHeaderCommand() {
        StringBuilder headerCommand = new StringBuilder();
        if (!this.headerFileSet.isEmpty()) {
            for (String file : this.headerFileSet) {
                headerCommand.append("#include <" + file + ">\n");
            }
            headerCommand.append("\n");
        }
        if (!this.definitionSet.isEmpty()) {
            for (String command : this.definitionSet) {
                headerCommand.append(command + "\n");
            }
            headerCommand.append("\n");
        }
        if (!this.functionNameSet.isEmpty()) {
            for (String functionName : this.functionNameSet) {
                headerCommand.append("void " + functionName + "();\n");
            }
            headerCommand.append("\n");
        }
        headerCommand.append("void setup()\n{\n");
        if (!this.inputPinSet.isEmpty()) {
            for (Long pinNumber : this.inputPinSet) {
                headerCommand.append("pinMode( " + pinNumber + ", INPUT);\n");
            }
        }
        if (!this.outputPinSet.isEmpty()) {
            for (Long pinNumber : this.outputPinSet) {
                headerCommand.append("pinMode( " + pinNumber + ", OUTPUT);\n");
            }
        }
        if (!this.setupCommand.isEmpty()) {
            for (String command : this.setupCommand) {
                headerCommand.append(command + "\n");
            }
        }
        headerCommand.append("}\n\n");
        return headerCommand.toString();
    }

    public String translate(Long blockId) throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlockFactory translatorBlockFactory = new TranslatorBlockFactory();
        Block block = this.workspace.getEnv().getBlock(blockId);
        TranslatorBlock rootTranslatorBlock = translatorBlockFactory.buildTranslatorBlock(this, blockId, block.getGenusName(), "", "", block.getBlockLabel());
        return rootTranslatorBlock.toCode();
    }

    public BlockAdaptor getBlockAdaptor() {
        return this.blockAdaptor;
    }

    public void reset() {
        this.headerFileSet = new HashSet<String>();
        this.definitionSet = new HashSet<String>();
        this.setupCommand = new LinkedList<String>();
        this.functionNameSet = new HashSet<String>();
        this.inputPinSet = new HashSet<Long>();
        this.outputPinSet = new HashSet<Long>();
        this.bodyTranslatreFinishCallbackSet = new HashSet<TranslatorBlock>();
        this.numberVariableSet = new HashMap<String, String>();
        this.booleanVariableSet = new HashMap<String, String>();
        this.blockAdaptor = this.buildOpenBlocksAdaptor();
        this.variableCnt = 0;
    }

    private BlockAdaptor buildOpenBlocksAdaptor() {
        return new OpenBlocksAdaptor();
    }

    public void addHeaderFile(String headerFile) {
        this.headerFileSet.add(headerFile);
    }

    public void addSetupCommand(String command) {
        if (!this.setupCommand.contains(command)) {
            this.setupCommand.add(command);
        }
    }

    public void addDefinitionCommand(String command) {
        this.definitionSet.add(command);
    }

    public void addInputPin(Long pinNumber) {
        this.inputPinSet.add(pinNumber);
    }

    public void addOutputPin(Long pinNumber) {
        this.outputPinSet.add(pinNumber);
    }

    public String getNumberVariable(String userVarName) {
        return this.numberVariableSet.get(userVarName);
    }

    public String getBooleanVariable(String userVarName) {
        return this.booleanVariableSet.get(userVarName);
    }

    public void addNumberVariable(String userVarName, String internalName) {
        this.numberVariableSet.put(userVarName, internalName);
    }

    public void addBooleanVariable(String userVarName, String internalName) {
        this.booleanVariableSet.put(userVarName, internalName);
    }

    public void addFunctionName(Long blockId, String functionName) throws SubroutineNameDuplicatedException {
        if (functionName.equals("loop") || functionName.equals("setup") || this.functionNameSet.contains(functionName)) {
            throw new SubroutineNameDuplicatedException(blockId);
        }
        this.functionNameSet.add(functionName);
    }

    public boolean containFunctionName(String name) {
        return this.functionNameSet.contains(name.trim());
    }

    public String buildVariableName() {
        return this.buildVariableName("");
    }

    public String buildVariableName(String reference) {
        ++this.variableCnt;
        String varName = variablePrefix + this.variableCnt + "_";
        for (int i = 0; i < reference.length(); ++i) {
            char c = reference.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') continue;
            varName = varName + c;
        }
        return varName;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Block getBlock(Long blockId) {
        return this.workspace.getEnv().getBlock(blockId);
    }

    public void registerBodyTranslateFinishCallback(TranslatorBlock translatorBlock) {
        this.bodyTranslatreFinishCallbackSet.add(translatorBlock);
    }

    public void beforeGenerateHeader() {
        for (TranslatorBlock translatorBlock : this.bodyTranslatreFinishCallbackSet) {
            translatorBlock.onTranslateBodyFinished();
        }
    }
}

