/* -*- c++ -*- */
#ifndef AKAXISO_SCHEMASTRUCTURE_HPP__
#define AKAXISO_SCHEMASTRUCTURE_HPP__

#define NS_XMLSCHEMA "http://www.w3.org/2001/XMLSchema"

#include <list>
#include <sstream>
#include <akaxiso/akaxiso.h>

namespace xs {

  typedef std::list<aka::item> Particles;

  struct ComplexType {
    Particles particles_;
    aka::qname name_;
  };

  typedef std::list<ComplexType> ComplexTypes;

  struct Element {
    Element(){}
    aka::qname name_;
    aka::qname type_;
    aka::qname ref_;
    long minOccurs_;
    long maxOccurs_;
    ComplexTypes complexTypes_;
  };

  struct GlobalElement {
    aka::qname name_;
    aka::qname type_;
    ComplexTypes complexTypes_;
  };


  struct Attribute {
    aka::qname name_;
    aka::qname type_;
  };

  typedef std::list<Element> Elements;

  struct Sequence {
    Elements elements_;
  };

  struct Choice {
    Elements elements_;
    long minOccurs_;
    long maxOccurs_;
  };

  typedef std::list<aka::item> TopLevelNodes;

  struct Schema {
    TopLevelNodes nodes_;
    std::string targetNamespace_;
  };


  void define_schemadoc();
  void serialize(const aka::document &doc);

  inline bool is_array(const aka::occurence &occ) {
    return (occ.minOccurs_ != 1) || (occ.maxOccurs_ != 1);
  }

} 




#endif
