// -*- c++ -*-
#ifndef PROJECT_MAP_H__
#define PROJECT_MAP_H__

#include <list>
#include <akaxiso/content_model.h>

namespace pj {

  typedef std::map<std::string, std::string> MemberMap;
  typedef MemberMap::value_type MemberPair;

  struct OrderedTeam {
    std::string name_;
    std::string url_;
    MemberMap members_;
  };


  struct SimpleContentItemLeaf : 
    public aka::simplecontent<pj::MemberPair, SimpleContentItemLeaf> {
    void model() {
      //    static_typeinfo().set_typename("cuppa:member");
      value(&pj::MemberPair::first);
      attribute("cuppa:title", &pj::MemberPair::second);
    }
  };

  struct SequenceItemLeaf : 
    public aka::sequence<pj::MemberPair, SequenceItemLeaf> {
    void model() {
      //    static_typeinfo().set_typename("cuppa:member");
      member("cuppa:name", &pj::MemberPair::first);
      member("cuppa:title", &pj::MemberPair::second);
    }
  };


  typedef aka::associative_array<pj::MemberMap, pj::SimpleContentItemLeaf> 
  SimpleContentMemberMapLeaf; 

  typedef aka::associative_array<pj::MemberMap, pj::SequenceItemLeaf> 
  SequenceMemberMapLeaf; 

  struct OrderedSimpleContentTeamLeaf : public aka::sequence<pj::OrderedTeam, 
					pj::OrderedSimpleContentTeamLeaf> {
    void model() {
      //    static_typeinfo().set_typename("cuppa:team");
      member("cuppa:project_name", &pj::OrderedTeam::name_);
      member("cuppa:url", &pj::OrderedTeam::url_);
      enclose("cuppa:members");
      ;  member simplecontents("cuppa:member", &pj::OrderedTeam::members_, 
			       SimpleContentMemberMapLeaf());
      ;  simplecontents.occurence(0, aka::unbounded);
      disclose("cuppa:members");
    }
  };


  struct OrderedSequenceTeamLeaf : public aka::sequence<pj::OrderedTeam, 
				   pj::OrderedSequenceTeamLeaf> {
    void model() {
      //    static_typeinfo().set_typename("cuppa:team");
      member("cuppa:project_name", &pj::OrderedTeam::name_);
      member("cuppa:url", &pj::OrderedTeam::url_);
      enclose("cuppa:members");
      {
	member sequences("cuppa:member", 
			 &pj::OrderedTeam::members_, 
			 SequenceMemberMapLeaf());
	sequences.occurence(0, aka::unbounded);
      }
      disclose("cuppa:members");
    }
  };

}



#endif
