// -*- c++ -*-
#ifndef PROJECT_H__
#define PROJECT_H__

#include <list>
#include <akaxiso/content_model.h>

namespace pj {

  struct Member {
    Member(){}
    Member(const std::string &name, const std::string &title) 
      : name_(name), title_(title){}
    std::string name_;
    std::string title_;
  };

  typedef std::list<Member> Members;

  struct Team {
    std::string name_;
    std::string url_;
    Members members_;
  };

}

namespace xiso {

  template<>
  struct leaf<pj::Member> : public aka::sequence<pj::Member> {
    void model() {
      member("cuppa:name", &pj::Member::name_);
      member("cuppa:title", &pj::Member::title_);
    }
  };

  template<>
  struct leaf<pj::Members> : public aka::sequential_array<pj::Members> {  };

  template<>
  struct leaf<pj::Team> : public aka::sequence<pj::Team> {
    void model() {
      member("cuppa:project_name", &pj::Team::name_);
      member("cuppa:url", &pj::Team::url_);
      enclose("cuppa:members");
      ; member("cuppa:member", &pj::Team::members_).occurence(0, aka::unbounded);
      disclose("cuppa:members");
    }
  };
}

#endif
