#include "simplecontent_handler.h"
#include "sequence_handler.h"
#include "simplecontent_handler.h"

#include <cassert>
#include <sstream>

using namespace aka2;
  
simplecontent_handler::simplecontent_handler(const qname &tagname, void *sim, int depth, 
					     const simplecontent_op &sop, 
					     parser_context &context) 
  : handler(context, depth, tagname), sim_(sim), sop_(sop) {
}


parse_result simplecontent_handler::query_element(const qname &tagname, 
						  const attribute_values &attrs, 
						  const global_attributes &gattrs) {
  assert(!"Must not be called.");
  return ok;
}


parse_result simplecontent_handler::end_element(const qname &tagname) {
  return ok;
}


bool simplecontent_handler::parse_entity(const std::string &entity, 
					 const global_attributes &gattrs) {
  std::istringstream istm(entity);
  const member_type &vtype = sop_.get_valuetype();
  memberpair mpair = vtype.get_member(sim_);
  assert(mpair.op_.get_schematype() == simpletype_id);

  try {
    static_cast<const simpletype_op&>(mpair.op_).read_text(mpair.e_, istm, *gattrs_);
    return true;
  }
  catch ( ... /* !!!!!!!! */ ) {
    return false;
  }
}

memberpair simplecontent_handler::get_element() {
  return memberpair(sim_, sop_);
}

void simplecontent_handler::receive_child(const memberpair &mpair) {
  assert(& sop_.get_valuetype().get_member(sim_).op_ == & mpair.op_);
}

bool simplecontent_handler::can_skip()  {
  return false;
}
