// -*- c++ -*-
#ifndef CDOM_XERCESC_DOCUMENTHANDLER_H__
#define CDOM_XERCESC_DOCUMENTHANDLER_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/document.h>
#include <akaxiso/classes/attribute.h>
#include <akaxiso/parser/handler.h>


namespace aka2 {

  class locator;

  
  class document_handler {
  public:
    document_handler();
    ~document_handler();

    void startElement(const qname &tagname, attribute_values& attrs);
    void characters(const char* chars, const unsigned int length);
    void endElement(const qname &tagname);
    void set_locator(const locator* const locator);
    void set_source_name(const std::string &source_name) {
      context_.set_source_name(source_name);
    }
    void set_gattrs(global_attributes &gattrs) {
      gattrs_ = &gattrs;
    }

    document *adopt_document();
    const parser_context &get_context() const {
      return context_;
    }

    void start_prefix_mapping(const std::string &prefix, const std::string &uri);
    void end_prefix_mapping(const std::string &prefix);

    global_attributes &get_global_attributes() {
      return *gattrs_;
    }

    document get_document() { return doc_; }



  protected:
    parse_result go_up(const qname& tagname);

  protected:
    std::string charsbuf_;
    parser_context context_;
    global_attributes *gattrs_;
    global_attributes default_attrs_;
    document doc_;
    int depth_;
  };

}

#endif

