#include "any_handler.h"

#include <cassert>

using namespace aka2;

any_handler::any_handler(const qname &tagname, any &an, int depth,
			 const element_op &eop,
			 parser_context &context)  
  : handler(context, depth, tagname) , an_(an), eop_(eop), any_depth_(0) {
  an_.tagname_ = tagname;
}


parse_result any_handler::query_element(const qname &tagname, const attribute_values &attrs, 
					const global_attributes &gattrs){

  ++any_depth_;

  std::ostringstream ostm;
  ostm << "<" << tagname;
  for (attribute_values::const_iterator itattr = attrs.begin();
       itattr != attrs.end(); ++itattr) {
    ostm << " " << itattr->first << "=\"" << itattr->second << "\"";
  }

  an_.value_ += ostm.rdbuf()->str();
  return ok;
}


parse_result any_handler::find_particle(const qname &tagname, const attribute_values &attrs, 
					const global_attributes &gattrs){
  assert(!"must not be called.");
  return error;
}

parse_result any_handler::end_element(const qname &tagname){
  std::ostringstream ostm;
  ostm << "</" << tagname << ">";
  an_.value_ += tagname.qualified();
  return ok;
}


bool any_handler::parse_entity(const std::string &entity, 
				    const global_attributes &gattrs) {
  an_.value_ += entity;
  return true;
}


memberpair any_handler::get_element() {
  return memberpair(&an_, eop_);
}

void any_handler::receive_child(const memberpair &mpair) {
  assert(!"Must not be called.");
}

bool any_handler::can_skip() {
  return false;
}

