#include "global_attributes.h"
#include "namespaces.h"

using namespace aka2;

void global_attributes::associate_namespace_prefix(const std::string &prefix, const std::string &uri) {
  id_type id = namespaces().register_namespace_uri(uri);
  prefixes_.assign_prefix(prefix, id);
}


void global_attributes::clear_namespace_prefix(const std::string &prefix) {
  prefixes_.clear_prefix(prefix);
}


void global_attributes::initialize() {
  prefixes_.initialize();
}

void global_attributes::uninitialize() {
  prefixes_.uninitialize();
}

