/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PImage;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.sg.SGChannel;
import quicktime.std.sg.SGDeviceList;
import quicktime.std.sg.SGVideoChannel;
import quicktime.std.sg.SequenceGrabber;
import quicktime.std.sg.VideoDigitizer;
import quicktime.util.EndianOrder;
import quicktime.util.RawEncodedImage;

public class Capture
extends PImage
implements Runnable {
    public static final int COMPOSITE = 0;
    public static final int SVIDEO = 1;
    public static final int COMPONENT = 2;
    public static final int TUNER = 6;
    public static final int NTSC = 0;
    public static final int PAL = 1;
    public static final int SECAM = 2;
    Method captureEventMethod;
    String name;
    Thread runner;
    boolean available = false;
    public int[] data;
    public int dataWidth;
    public int dataHeight;
    public int dataRowBytes;
    public boolean crop;
    public int cropX;
    public int cropY;
    public int cropW;
    public int cropH;
    public int frameRate;
    public RawEncodedImage raw;
    public SequenceGrabber capture;
    public SGVideoChannel channel;
    protected QDRect qdrect;

    public Capture(PApplet parent, int requestWidth, int requestHeight) {
        this(parent, requestWidth, requestHeight, null, 30);
    }

    public Capture(PApplet parent, int reqWidth, int reqHeight, int frameRate) {
        this(parent, reqWidth, reqHeight, null, frameRate);
    }

    public Capture(PApplet parent, int reqWidth, int reqHeight, String name) {
        this(parent, reqWidth, reqHeight, name, 30);
    }

    public Capture(PApplet parent, int requestWidth, int requestHeight, String name, int frameRate) {
        this.init(parent, requestWidth, requestHeight, name, frameRate);
    }

    public void init(PApplet parent, int requestWidth, int requestHeight, String name, int frameRate) {
        this.parent = parent;
        this.name = name;
        this.frameRate = frameRate;
        try {
            QTSession.open();
        }
        catch (QTException e) {
            e.printStackTrace(System.out);
            return;
        }
        try {
            this.qdrect = new QDRect(requestWidth, requestHeight);
            QDGraphics qdgraphics = null;
            qdgraphics = EndianOrder.isNativeLittleEndian() ? new QDGraphics(1111970369, this.qdrect) : new QDGraphics(QDGraphics.kDefaultPixelFormat, this.qdrect);
            this.capture = new SequenceGrabber();
            this.capture.setGWorld(qdgraphics, null);
            this.channel = new SGVideoChannel(this.capture);
            this.channel.setBounds(this.qdrect);
            this.channel.setUsage(2);
            this.capture.startPreview();
            PixMap pixmap = qdgraphics.getPixMap();
            this.raw = pixmap.getPixelData();
            if (name != null && name.length() > 0) {
                this.channel.setDevice(name);
            }
            this.dataRowBytes = this.raw.getRowBytes();
            this.dataWidth = this.dataRowBytes / 4;
            this.dataHeight = this.raw.getSize() / this.dataRowBytes;
            if (this.dataWidth != requestWidth) {
                this.crop = true;
                this.cropX = 0;
                this.cropY = 0;
                this.cropW = requestWidth;
                this.cropH = requestHeight;
            }
            super.init(requestWidth, requestHeight, 1);
            parent.registerDispose((Object)this);
            try {
                this.captureEventMethod = parent.getClass().getMethod("captureEvent", Capture.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.runner = new Thread(this);
            this.runner.start();
        }
        catch (QTException qte) {
            int errorCode = qte.errorCode();
            if (errorCode == -9405) {
                parent.die("No capture could be found, or the VDIG is not installed correctly.", (Exception)((Object)qte));
            } else {
                parent.die("Error while setting up Capture", (Exception)((Object)qte));
            }
        }
        catch (Exception e) {
            parent.die("Error while setting up Capture", e);
        }
    }

    public boolean available() {
        return this.available;
    }

    public void crop(int x, int y, int w, int h) {
        this.crop = true;
        this.cropX = Math.max(0, x);
        this.cropY = Math.max(0, y);
        this.cropW = Math.min(w, this.dataWidth);
        this.cropH = Math.min(this.dataHeight, y + h) - this.cropY;
        if (this.cropW != this.width || this.cropH != this.height) {
            this.init(w, h, 1);
        }
    }

    public void noCrop() {
        this.crop = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        this.loadPixels();
        int[] nArray = this.pixels;
        synchronized (this.pixels) {
            if (this.crop) {
                if (this.data == null) {
                    this.data = new int[this.dataWidth * this.dataHeight];
                }
                this.raw.copyToArray(0, this.data, 0, this.dataWidth * this.dataHeight);
                int sourceOffset = this.cropX + this.cropY * this.dataWidth;
                int destOffset = 0;
                int y = 0;
                while (y < this.cropH) {
                    System.arraycopy(this.data, sourceOffset, this.pixels, destOffset, this.cropW);
                    sourceOffset += this.dataWidth;
                    destOffset += this.width;
                    ++y;
                }
            } else {
                this.raw.copyToArray(0, this.pixels, 0, this.width * this.height);
            }
            this.available = false;
            this.updatePixels();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (Thread.currentThread() == this.runner && this.capture != null) {
            try {
                SequenceGrabber sequenceGrabber = this.capture;
                synchronized (sequenceGrabber) {
                    this.capture.idle();
                    this.available = true;
                    if (this.captureEventMethod != null) {
                        try {
                            this.captureEventMethod.invoke((Object)this.parent, this);
                        }
                        catch (Exception e) {
                            System.err.println("Disabling captureEvent() for " + this.name + " because of an error.");
                            e.printStackTrace();
                            this.captureEventMethod = null;
                        }
                    }
                }
            }
            catch (QTException e) {
                this.errorMessage("run", (Exception)((Object)e));
            }
            try {
                Thread.sleep(1000 / this.frameRate);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void frameRate(int iframeRate) {
        if (iframeRate <= 0) {
            System.err.println("Capture: ignoring bad frameRate of " + iframeRate + " fps.");
            return;
        }
        this.frameRate = iframeRate;
    }

    public void stop() {
        if (this.capture != null) {
            try {
                this.capture.stop();
            }
            catch (StdQTException e) {
                e.printStackTrace();
            }
            this.capture = null;
        }
        this.runner = null;
    }

    public void dispose() {
        this.stop();
        QTSession.close();
    }

    protected void errorMessage(String where, Exception e) {
        this.parent.die("Error inside Capture." + where + "()", e);
    }

    public void source(int which) {
        try {
            VideoDigitizer digitizer = this.channel.getDigitizerComponent();
            int count = digitizer.getNumberOfInputs();
            int i = 0;
            while (i < count) {
                if (digitizer.getInputFormat(i) == which) {
                    digitizer.setInput(i);
                    return;
                }
                ++i;
            }
            throw new RuntimeException("The specified source() is not available.");
        }
        catch (StdQTException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not set the video input source.");
        }
    }

    public void format(int which) {
        try {
            VideoDigitizer digitizer = this.channel.getDigitizerComponent();
            digitizer.setInputStandard(which);
        }
        catch (StdQTException e) {
            e.printStackTrace();
        }
    }

    public void settings() {
        block4: {
            try {
                this.capture.stop();
                this.channel.setBounds(this.qdrect);
                this.channel.settingsDialog();
            }
            catch (StdQTException qte) {
                int errorCode = qte.errorCode();
                if (errorCode == -128) break block4;
                qte.printStackTrace();
                throw new RuntimeException("Error inside Capture.settings()");
            }
        }
        try {
            this.capture.startPreview();
        }
        catch (StdQTException qte) {
            qte.printStackTrace();
        }
    }

    public static String[] list() {
        try {
            QTSession.open();
            SequenceGrabber grabber = new SequenceGrabber();
            SGVideoChannel channel = new SGVideoChannel(grabber);
            SGDeviceList deviceList = channel.getDeviceList(0);
            String[] listing = new String[deviceList.getCount()];
            int i = 0;
            while (i < deviceList.getCount()) {
                listing[i] = deviceList.getDeviceName(i).getName();
                ++i;
            }
            grabber.disposeChannel((SGChannel)channel);
            QTSession.close();
            return listing;
        }
        catch (QTException qte) {
            int errorCode = qte.errorCode();
            if (errorCode == -9405) {
                throw new RuntimeException("Couldn't find any capture devices, read the video reference for more info.");
            }
            qte.printStackTrace();
            throw new RuntimeException("Problem listing capture devices, read the video reference for more info.");
        }
    }
}

