/*
 * Decompiled with CFR 0.152.
 */
package hypermedia.video;

import hypermedia.video.Blob;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import processing.core.PApplet;
import processing.core.PImage;

public class OpenCV {
    public static final int SOURCE = 0;
    public static final int BUFFER = 1;
    public static final int MEMORY = 2;
    public static final int RGB = 1;
    public static final int GRAY = 12;
    public static final int THRESH_BINARY = 0;
    public static final int THRESH_BINARY_INV = 1;
    public static final int THRESH_TRUNC = 2;
    public static final int THRESH_TOZERO = 3;
    public static final int THRESH_TOZERO_INV = 4;
    public static final int THRESH_OTSU = 8;
    public static final int FLIP_VERTICAL = 0;
    public static final int FLIP_HORIZONTAL = 1;
    public static final int FLIP_BOTH = -1;
    public static final int INTER_NN = 0;
    public static final int INTER_LINEAR = 1;
    public static final int INTER_CUBIC = 2;
    public static final int INTER_AREA = 3;
    public static final int MAX_VERTICES = 1024;
    public static final int BLUR = 1;
    public static final int GAUSSIAN = 2;
    public static final int MEDIAN = 3;
    public static final int BILATERAL = 4;
    public static final int MOVIE_MILLISECONDS = 0;
    public static final int MOVIE_FRAMES = 1;
    public static final int MOVIE_RATIO = 2;
    public static final int MOVIE_WIDTH = 3;
    public static final int MOVIE_HEIGHT = 4;
    public static final int MOVIE_FPS = 5;
    public static final int MOVIE_FRAME_COUNT = 7;
    public static final int MOVIE_FORMAT = 8;
    public static final int MOVIE_MODE = 9;
    public static final int MOVIE_BRIGHTNESS = 10;
    public static final int MOVIE_CONTRAST = 11;
    public static final int MOVIE_SATURATION = 12;
    public static final int MOVIE_HUE = 13;
    public static final int MOVIE_GAIN = 14;
    public static final int MOVIE_CONVERT_RGB = 15;
    public static final int HAAR_DO_CANNY_PRUNING = 1;
    public static final int HAAR_SCALE_IMAGE = 2;
    public static final int HAAR_FIND_BIGGEST_OBJECT = 4;
    public static final int HAAR_DO_ROUGH_SEARCH = 8;
    public static final String CASCADE_FRONTALFACE_ALT_TREE = "haarcascade_frontalface_alt_tree.xml";
    public static final String CASCADE_FRONTALFACE_ALT = "haarcascade_frontalface_alt.xml";
    public static final String CASCADE_FRONTALFACE_ALT2 = "haarcascade_frontalface_alt2.xml";
    public static final String CASCADE_FRONTALFACE_DEFAULT = "haarcascade_frontalface_default.xml";
    public static final String CASCADE_PROFILEFACE = "haarcascade_profileface.xml";
    public static final String CASCADE_FULLBODY = "haarcascade_fullbody.xml";
    public static final String CASCADE_LOWERBODY = "haarcascade_lowerbody.xml";
    public static final String CASCADE_UPPERBODY = "haarcascade_upperbody.xml";
    protected PApplet parent = null;
    public int width = 0;
    public int height = 0;
    private int brightness = 0;
    private int contrast = 0;
    private static String OS = System.getProperty("os.name").toLowerCase();

    public OpenCV() {
        this(null);
    }

    public OpenCV(PApplet parent) {
        this.parent = parent;
        try {
            if (parent instanceof PApplet) {
                parent.registerDispose((Object)this);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void dispose() {
        this.stop();
    }

    public native void allocate(int var1, int var2);

    private native void deallocate(int var1);

    public void stop() {
        this.deallocate(-1);
    }

    public void remember() {
        this.remember(0, -2);
    }

    public void remember(int type) {
        this.remember(type, -2);
    }

    public native void remember(int var1, int var2);

    public native void convert(int var1);

    public native void absDiff();

    public native void flip(int var1);

    public native void threshold(float var1, float var2, int var3);

    public void threshold(float value) {
        this.threshold(value, 255.0f, 0);
    }

    public void brightness(int value) {
        this.brightness = Math.min(128, Math.max(value, -128));
        this.brightnessContrast(this.brightness, this.contrast);
    }

    public void contrast(int value) {
        this.contrast = Math.min(128, Math.max(value, -128));
        this.brightnessContrast(this.brightness, this.contrast);
    }

    private native void brightnessContrast(int var1, int var2);

    public native void invert();

    public void blur(int type, int param1) {
        this.blur(type, param1, 0, 0.0f, 0.0f);
    }

    public native void blur(int var1, int var2, int var3, float var4, float var5);

    public native void interpolation(int var1);

    public void copy(PImage image) {
        this.copy(image, 0, 0, image.width, image.height, 0, 0, image.width, image.height);
    }

    public void copy(String file) {
        this.copy(file, 0, 0, -1, -1, 0, 0, -1, -1);
    }

    public void copy(PImage image, int sx, int sy, int swidth, int sheight, int dx, int dy, int dwidth, int dheight) {
        this.copy(image.pixels, image.width, sx, sy, swidth, sheight, dx, dy, dwidth, dheight);
    }

    public native void copy(String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public native void copy(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void restore() {
        this.restore(1);
    }

    public native void restore(int var1);

    public native int[] pixels(int var1);

    public int[] pixels() {
        return this.pixels(1);
    }

    public void loadImage(String file) {
        this.loadImage(file, -1, -1);
    }

    public native void loadImage(String var1, int var2, int var3);

    public PImage image() {
        return this.image(1);
    }

    public PImage image(int type) {
        if (this.width == 0 && this.height == 0) {
            System.err.println("OpenCV could not define source dimensions.\n");
            return null;
        }
        PImage img = new PImage(this.width, this.height);
        img.pixels = this.pixels(type);
        return img;
    }

    public Blob[] blobs(int minArea, int maxArea, int maxBlobs, boolean findHoles) {
        return this.blobs(minArea, maxArea, maxBlobs, findHoles, 1024);
    }

    public native Blob[] blobs(int var1, int var2, int var3, boolean var4, int var5);

    public void findContours(int minArea, int maxArea, int maxBlobs, boolean findHoles) {
        this.findContours(minArea, maxArea, maxBlobs, findHoles, 1024);
    }

    public native void findContours(int var1, int var2, int var3, boolean var4, int var5);

    public native int blobCount();

    public native float area(int var1);

    public native float arcLength(int var1);

    public native Point centroid(int var1);

    public native Rectangle rectangle(int var1);

    public native int pointCount(int var1);

    public native Point[] points(int var1);

    public native boolean isHole(int var1);

    public void capture(int width, int height) {
        this.capture(width, height, 0);
    }

    public native void capture(int var1, int var2, int var3);

    public void movie(String filename) {
        this.loadMovie(filename, -1, -1);
    }

    public void movie(String filename, int width, int height) {
        this.loadMovie(filename, width, height);
    }

    private native void loadMovie(String var1, int var2, int var3);

    public native void read();

    public native float property(int var1);

    public void jump(int millis) {
        this.jump(millis, 0);
    }

    public void jump(float ratio) {
        this.jump(Math.max(Math.min(ratio, 1.0f), 0.0f), 2);
    }

    public native void jump(float var1, int var2);

    public void ROI(Rectangle rect) {
        if (rect == null) {
            this.ROI(0, 0, this.width, this.height);
        } else {
            this.ROI(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public native void ROI(int var1, int var2, int var3, int var4);

    public String absolutePath(String file) {
        String[] paths = new String[]{};
        String pwd = this.parent != null ? this.parent.sketchPath("") : System.getProperty("user.dir") + File.separator;
        String dat = this.parent != null ? this.parent.dataPath("") : pwd + "data" + File.separator;
        String home = System.getProperty("user.home");
        if (OS.indexOf("windows") != -1) {
            String[] PATH = System.getProperty("java.library.path").split(";");
            for (int i = 0; i < PATH.length; ++i) {
                if (PATH[i].indexOf("OpenCV") == -1) continue;
                paths = new String[]{dat, pwd, PATH[i].replaceFirst("bin", "") + "data\\haarcascades\\"};
                break;
            }
        }
        if (OS.indexOf("mac") != -1) {
            paths = new String[]{dat, pwd, "/System/Library/Frameworks/OpenCV.framework/Resources/", "/Library/Frameworks/OpenCV.framework/Resources/", home + "/Library/Frameworks/OpenCV.framework/Resources/"};
        }
        if (OS.indexOf("linux") != -1) {
            paths = new String[]{dat, pwd, "/usr/share/opencv/haarcascades/", "/usr/local/share/opencv/haarcascades/"};
        }
        if (new File(file).isAbsolute()) {
            return file;
        }
        for (int i = 0; i < paths.length; ++i) {
            if (!new File(paths[i] + file).exists()) continue;
            return paths[i] + file;
        }
        try {
            return this.getClass().getClassLoader().getResource(file).getPath();
        }
        catch (NullPointerException e) {
            return file;
        }
    }

    public native void cascade(String var1);

    public native Rectangle[] detect(float var1, int var2, int var3, int var4, int var5);

    public Rectangle[] detect() {
        return this.detect(1.1f, 3, 0, 0, 0);
    }

    static {
        try {
            System.loadLibrary("OpenCV");
        }
        catch (UnsatisfiedLinkError e) {
            String err = "!!! required library not found : " + e.getMessage() + "\n" + "Verify that the java.library.path property is correctly set and ";
            if (OS.indexOf("mac") != -1) {
                err = err + "the opencv.framework exists in '/Library/Frameworks' folder";
            }
            if (OS.indexOf("windows") != -1) {
                err = err + "the '\\path\\to\\OpenCV\\bin' exists in your system PATH";
            }
            if (OS.indexOf("linux") != -1) {
                err = err + "'libcxcore.so', 'libcv.so', 'libcvaux.so', 'libml.so', and 'libhighgui.so' are placed (or linked) in one of your system shared libraries folder";
            }
            System.err.println("\n" + err + "\n");
        }
    }
}

