/*
 * Decompiled with CFR 0.152.
 */
import hypermedia.video.OpenCV;
import java.awt.Rectangle;
import processing.core.PApplet;
import processing.core.PImage;
import processing.video.MovieMaker;

public class AhegaoMan
extends PApplet {
    boolean rec = true;
    int fps = 30;
    int w = 1280;
    int h = 720;
    int angle = 0;
    OpenCV opencv;
    MovieMaker mm;
    PImage img_back;
    PImage img_ahegao;
    PImage[] img_rotated = new PImage[360];

    public void setup() {
        this.size(this.w, this.h);
        String string = this.selectInput();
        this.opencv = new OpenCV((PApplet)this);
        this.opencv.movie(string, this.width, this.height);
        this.opencv.cascade("haarcascade_frontalface_alt.xml");
        this.img_back = this.loadImage("ahegao_back.png");
        this.MakeRotatedImage();
        this.img_ahegao = this.loadImage("ahegao.png");
        this.imageMode(0);
        if (this.rec) {
            this.mm = new MovieMaker((PApplet)this, this.w, this.h, "ahegao.mov", this.fps, 1919973985, 1024);
            this.frameRate(this.fps);
        }
    }

    public void MakeRotatedImage() {
        float f = 0.0f;
        this.img_back.loadPixels();
        int n = this.img_back.width / 2;
        int n2 = this.img_back.height / 2;
        int n3 = 0;
        while (n3 < 360) {
            this.img_rotated[n3] = this.createImage(this.img_back.width, this.img_back.height, 2);
            ++n3;
        }
        n3 = 0;
        while (n3 < 360) {
            f = (float)Math.PI * 2 * (float)n3 / 360.0f;
            int n4 = (int)(AhegaoMan.sin((float)f) * 1024.0f);
            int n5 = (int)(AhegaoMan.cos((float)f) * 1024.0f);
            int n6 = 0;
            while (n6 < this.img_back.height) {
                int n7 = 0;
                while (n7 < this.img_back.width) {
                    int n8 = ((n7 - n) * n5 - (n6 - n2) * n4 >> 10) + n;
                    int n9 = ((n7 - n) * n4 + (n6 - n2) * n5 >> 10) + n2;
                    if (n8 >= 0 && n8 < this.img_back.width && n9 >= 0 && n9 < this.img_back.height) {
                        this.img_rotated[n3].pixels[n7 + n6 * this.img_back.width] = this.img_back.pixels[n8 + n9 * this.img_back.width];
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n3;
        }
    }

    public void draw() {
        this.opencv.read();
        this.image(this.opencv.image(), 0.0f, 0.0f);
        Rectangle[] rectangleArray = this.opencv.detect();
        int n = 0;
        while (n < rectangleArray.length) {
            this.image(this.img_rotated[this.angle], (float)rectangleArray[n].x - (float)rectangleArray[n].width * 0.2f, (float)rectangleArray[n].y - (float)rectangleArray[n].height * 0.2f, (float)rectangleArray[n].width * 1.4f, (float)rectangleArray[n].height * 1.4f);
            this.image(this.img_ahegao, (float)rectangleArray[n].x + (float)rectangleArray[n].width * 0.1f, (float)rectangleArray[n].y + (float)rectangleArray[n].height * 0.1f, (float)rectangleArray[n].width * 0.8f, (float)rectangleArray[n].height * 0.8f);
            ++n;
        }
        if (this.rec) {
            this.mm.addFrame();
        }
        this.angle += 3;
        if (this.angle > 359) {
            this.angle = 0;
        }
    }

    public void keyPressed() {
        if (this.key == ' ') {
            if (this.rec) {
                this.mm.finish();
            }
            this.exit();
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "AhegaoMan"});
    }
}

