﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Drawing;

using System.Windows.Forms;

using nispi.controlclass;

namespace nispi.OptionControl
{
    //すべてのコントロールの縦の感覚は３０
    class OptionMainForm
    {
        public FormParts optionFormParts;
        public TabControlParts optionTabControlParts;

        public AbonOption abonOption;
        public HistoryOption histroyOption;
        public OtherOption otherOption;
        public BrowserOption browserOption;
        /////////
        //外観
        public OutWardForm outWardForm;
        public OutWardTab outWardTab;
        public OutWardList outWardList;
        public OutWardBrowser outWardBrowser;

        public OutWardMap outWardMap;
        public OutWardMenu outWardMenu;

        /////////
        public LogInOption logInOption;
        public WriteOption writeOption;
        //public AnalysisOption analysisOption;
        public string fontName = "Meiryo UI";
        public float fontSize = 9.75f;

        public string fontNameStd = "ＭＳ Ｐゴシック";
        public float fontSizeStd = 12.0f;
        
        public ButtonParts OKButton;
        public ButtonParts CloseButton;
        public ButtonParts UpdateButton;

        public OptionMainForm()
        {
            optionFormParts = new FormParts();
            optionFormParts.Text = "設定";
            optionFormParts.Name = "optionFormPart";
            optionFormParts.Hide();
            //optionFormParts.Owner = Const.form.mainForm.control;//.control.TopMost = true;
            optionFormParts.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;// ;////.FixedSingle;
            //optionFormParts.Location = new Point(Const.form.mainForm.Location.X + 50, Const.form.mainForm.Location.Y + 50);
            optionFormParts.SetFormClosing(new FormPartsDelegate.MultiFormClosingEventHandler(optionFormParts_FormClosing));//.FormClosing += new FormClosingEventHandler(optionFormParts_FormClosing);
            optionFormParts.SetFont(fontName, fontSize);
            optionFormParts.Size = new Size(600, 620);

            optionTabControlParts = new TabControlParts();
            optionTabControlParts.Name = "optionTabControlParts";
            optionTabControlParts.Size = new Size(optionFormParts.ClientSize.Width, optionFormParts.ClientSize.Height - 40);
            optionTabControlParts.Location = new Point(0,0);
            optionTabControlParts.SetOptionParts();
            optionTabControlParts.control.Multiline = false;

            optionFormParts.AddControl(optionTabControlParts);

            //外観
            outWardForm = new OutWardForm(this);
            outWardTab = new OutWardTab(this);
            outWardList = new OutWardList(this);
            outWardBrowser = new OutWardBrowser(this);

            outWardMap = new OutWardMap(this);
            outWardMenu = new OutWardMenu(this);


            //ブラウザ
            browserOption = new BrowserOption(this);
            //書き込み
            writeOption = new WriteOption(this);
            //ログイン
            logInOption = new LogInOption(this);
            //あぼん
            abonOption = new AbonOption(this);
            //履歴
            histroyOption = new HistoryOption(this);
            //解析
            //analysisOption = new AnalysisOption(this);
            //その他
            otherOption = new OtherOption(this);



            optionTabControlParts.SelectedIndex = 0;

            OKButton = new ButtonParts();
            CloseButton = new ButtonParts();
            UpdateButton = new ButtonParts();

            OKButton.Location = new Point(300, optionFormParts.ClientSize.Height - 35);
            OKButton.Size = new Size(80, 30);
            OKButton.SetFont(fontName, fontSize);
            OKButton.Text = "ＯＫ";
            OKButton.Click +=new EventHandler(OKButton_Click);

            CloseButton.Location = new Point(390, optionFormParts.ClientSize.Height - 35);
            CloseButton.Size = new Size(80, 30);
            CloseButton.SetFont(fontName, fontSize);
            CloseButton.Text = "閉じる";
            CloseButton.Click += new EventHandler(CloseButton_Click);

            UpdateButton.Location = new Point(480, optionFormParts.ClientSize.Height - 35);
            UpdateButton.Size = new Size(80, 30);
            UpdateButton.SetFont(fontName, fontSize);
            UpdateButton.Text = "適用する";
            UpdateButton.Click += new EventHandler(UpdateButton_Click);

            optionFormParts.AddControl(OKButton);
            optionFormParts.AddControl(CloseButton);
            optionFormParts.AddControl(UpdateButton);

            //外観
            /*outWardForm.SetDataToGUI();
            outWardTab.SetDataToGUI();
            outWardList.SetDataToGUI();
            outWardBrowser.SetDataToGUI();

            outWardMenu.SetDataToGUI();
            outWardMap.SetDataToGUI();


            //analysisOption.SetDataToGUI();
            browserOption.SetDataToGUI();
            histroyOption.SetDataToGUI();
            logInOption.SetDataToGUI();
            otherOption.SetDataToGUI();
            writeOption.SetDataToGUI();*/
        }
        public void OpenOptionDialog()
        {
            //外観
            outWardForm.SetDataToGUI();
            outWardTab.SetDataToGUI();
            outWardList.SetDataToGUI();
            outWardBrowser.SetDataToGUI();

            outWardMenu.SetDataToGUI();
            outWardMap.SetDataToGUI();


            //analysisOption.SetDataToGUI();
            browserOption.SetDataToGUI();
            histroyOption.SetDataToGUI();
            logInOption.SetDataToGUI();
            otherOption.SetDataToGUI();
            writeOption.SetDataToGUI();

            optionFormParts.Location = new Point(Const.form.mainForm.Location.X + 50, Const.form.mainForm.Location.Y + 50);
            optionFormParts.Owner = Const.form.mainForm.control;
            optionFormParts.Show();
        }
        private void OKButton_Click(object sender, EventArgs e)
        {
            this.optionFormParts.Owner = null;

            SetOption();

            optionFormParts.Hide();
        }
        private void CloseButton_Click(object sender, EventArgs e)
        {
            this.optionFormParts.Owner = null;

            optionFormParts.Hide();
        }
        private void UpdateButton_Click(object sender, EventArgs e)
        {
            SetOption();
        }
        private void optionFormParts_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;

            this.optionFormParts.Owner = null;

            SetOption();

            optionFormParts.Hide();
        }

        private void SetOption()
        {
            browserOption.browserOptionEvent.SetAllOption();
            histroyOption.historyOptionEvent.SetAllOption();
            logInOption.logInOptionEvent.SetAllOption();
            otherOption.otherOptionEvent.SetAllOption();
            writeOption.writeOptionEvent.SetAllOption();


            //外観
            if ((outWardForm.outWardEventForm.changeFlag == true) ||
                (outWardTab.outWardEventTab.changeFlag == true) ||
                (outWardList.outWardOptionEventListView.changeFlag == true) ||
                (outWardBrowser.changeFlag == true) ||
                (outWardMenu.changeFlag == true) ||
                (outWardMap.changeFlag == true))
            {
                outWardForm.outWardEventForm.SetAllOption();
                outWardTab.outWardEventTab.SetAllOption();
                outWardList.outWardOptionEventListView.SetAllOption();
                outWardBrowser.SetAllOption();
                outWardMenu.SetAllOption();
                outWardMap.SetAllOption();

                //再起動する
                optionFormParts.Hide();
                System.Diagnostics.Process.Start("ExitAndRun.exe");
                return;
            }
        }
    }
}
