﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Xml.Linq;

namespace nispi.OptionControl
{
    class LogInOptionData : CommonInEvent
    {
        private Mutex mutex = new Mutex(false, "LogInOptionData");

        public bool isMaruAutoLogIn;
        public string maruID;
        public string maruPassWord;

        public bool isBeAutoLogIn;
        public string beID;
        public string bePassWord;

        public bool isSCBeAutoLogIn;
        public string scBeID;
        public string scBePassWord;

        public LogInOptionData()
        {
            GetXMLData();
        }
        public string ResetXML()
        {
            XNamespace ns = "LogInOptionData";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "IsMaruAutoLogIn", "False"),
                new XElement(ns + "MaruID", ""),
                new XElement(ns + "MaruPassWord", ""),

                new XElement(ns + "IsBeAutoLogIn", "False"),
                new XElement(ns + "BeID", ""),
                new XElement(ns + "BePassWord", ""),
                
                new XElement(ns + "IsSCBeAutoLogIn", "False"),
                new XElement(ns + "SCBeID", ""),
                new XElement(ns + "SCBePassWord", ""));

            FileIO.SaveShiftJis("setting", "login.xml", doc.ToString());

            return doc.ToString();
        }
        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "login.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "LogInOptionData";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                this.IsMaruAutoLogIn = doc2.Element(ns + "IsMaruAutoLogIn").Value;
                this.MaruID = doc2.Element(ns + "MaruID").Value;
                this.MaruPassWord = doc2.Element(ns + "MaruPassWord").Value;

                this.IsBeAutoLogIn = doc2.Element(ns + "IsBeAutoLogIn").Value;
                this.BeID = doc2.Element(ns + "BeID").Value;
                this.BePassWord = doc2.Element(ns + "BePassWord").Value;

                this.IsSCBeAutoLogIn = doc2.Element(ns + "IsSCBeAutoLogIn").Value;
                this.SCBeID = doc2.Element(ns + "SCBeID").Value;
                this.SCBePassWord = doc2.Element(ns + "SCBePassWord").Value;

            }
            catch { ;}
            mutex.ReleaseMutex();
        }
        public void SaveToFile()
        {
            mutex.WaitOne();

            XNamespace ns = "LogInOptionData";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "IsMaruAutoLogIn", this.IsMaruAutoLogIn),
                new XElement(ns + "MaruID", this.MaruID),
                new XElement(ns + "MaruPassWord", this.MaruPassWord),

                new XElement(ns + "IsBeAutoLogIn", this.IsBeAutoLogIn),
                new XElement(ns + "BeID", this.BeID),
                new XElement(ns + "BePassWord", this.BePassWord),
                
                new XElement(ns + "IsSCBeAutoLogIn", this.IsSCBeAutoLogIn),
                new XElement(ns + "SCBeID", this.SCBeID),
                new XElement(ns + "SCBePassWord", this.SCBePassWord));

            FileIO.SaveShiftJis("setting", "login.xml", doc.ToString());

            mutex.ReleaseMutex();
        }


        public string IsMaruAutoLogIn
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isMaruAutoLogIn= bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isMaruAutoLogIn;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }
        public string MaruID
        {
            set
            {
                mutex.WaitOne();
                this.maruID = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.maruID);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string MaruPassWord
        {
            set
            {
                mutex.WaitOne();
                this.maruPassWord = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.maruPassWord);
                mutex.ReleaseMutex();
                return data;
            }
        }
        //2ch.net
        public string IsBeAutoLogIn
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isBeAutoLogIn = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isBeAutoLogIn;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }
        public string BeID
        {
            set
            {
                mutex.WaitOne();
                this.beID = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.beID);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string BePassWord
        {
            set
            {
                mutex.WaitOne();
                this.bePassWord = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.bePassWord);
                mutex.ReleaseMutex();
                return data;
            }
        }
        //2ch.sc
        public string IsSCBeAutoLogIn
        {
            set
            {
                if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.isSCBeAutoLogIn = bool.Parse(value);
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                bool data = this.isSCBeAutoLogIn;
                mutex.ReleaseMutex();
                return data.ToString();
            }
        }
        public string SCBeID
        {
            set
            {
                mutex.WaitOne();
                this.scBeID = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.scBeID);
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string SCBePassWord
        {
            set
            {
                mutex.WaitOne();
                this.scBePassWord = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.scBePassWord);
                mutex.ReleaseMutex();
                return data;
            }
        }
    }
}