﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Text.RegularExpressions;

using System.Windows.Forms;

using nispi.controlclass;
using nispi;

namespace nispi.controlclass
{
    partial class TreeViewParts : ControlBase
    {
        //2ch
        //<BR><BR><B>運営BBS</B><BR>
        //<A HREF=http://livech.sakura.ne.jp/livesalon/>ｻﾛﾝｸﾗｼｶﾙ</A><br>
        public static Regex GROUP_REGEXP = new Regex("<B>(.*)</B>");
        public static Regex BOARD_REGEXP = new Regex("<A HREF=([^ ]*).*>(.*)</A>");

        //Blogban
        //<b>ニュース</b><br>
        //<a href="http://blogban.net/news/">BBNews</a><br>
        public static Regex GROUP_REGEXP_BLOGBAN = new Regex("<b>(.*)</b><br>"); 
        public static Regex BOARD_REGEXP_BLOGBAN = new Regex("<a href=\"([^ ]*).*\">(.*)</a><br>");

        //Shizu
        //<tr><td>■ 初心者・案内</td></tr>
        //<tr><td><a href="./rounge/index2.html" target="main">ラウンジ</a></td></tr>
        public static Regex GROUP_REGEXP_SHIZU = new Regex("<tr><td>■(.*)</td></tr>");
        public static Regex BOARD_REGEXP_SHIZU = new Regex("<tr><td><a href=\"([^ ]*).*\" target=\"main\">(.*)</a></td></tr>");

        //vip2ch
        //<BR><BR><B>VIPサービス</B><BR>
        //<A HREF="http://ex14.vip2ch.com/part4vip/vipbrowser.html">パート速報VIP</A><br>
        public static Regex GROUP_REGEXP_VIP2CH = new Regex("<BR><BR><B>(.*)サービス</B><BR>");
        public static Regex BOARD_REGEXP_VIP2CH = new Regex("<A HREF=\"([^ ]*)vip2ch.com(.*)vipbrowser.html\">(.*)</A><br>");

        //machi
        //まちBBSメニュー<hr>
        //□<a href="http://hokkaido.machi.to/hokkaidou/i/">まちBBS北海道</a><br>
        public static Regex GROUP_REGEXP_MACHIBBS = new Regex("まちBBSメニュー<hr>"); 
        public static Regex BOARD_REGEXP_MACHIBBS = new Regex("<a href=\"([^ ]*).*\">(.*)</a><br>");
        
        //public static TreeNode hitNode;
        //public static Color hitNodeColor;
        int selectedNodeNode = 0;
        int selectedNode = 0;
        string searchText = "";

        public void SearchTreeView(TreeViewParts treeViewParts, string searchText)
        {
            //前と同じ検索内容ならば
            if (this.searchText.Equals(searchText) == true)
            {
                selectedNodeNode += 1;
                //子ノードがノードの域を超えるならば、親ノードを一つ進めて子ノードはゼロにする
                if (treeViewParts.control.Nodes[selectedNode].Nodes.Count <= selectedNodeNode)
                {
                    selectedNode += 1;
                    selectedNodeNode = 0;
                    //親ノードが域を超えるならば両方ゼロにする
                    if (treeViewParts.control.Nodes.Count <= selectedNode)
                    {
                        selectedNode = 0;
                        selectedNodeNode = 0;
                    }
                }
            }
            //検索文字列が前と違うならば初期化
            else
            {
                selectedNode = 0;
                selectedNodeNode = 0;
            }

            this.searchText = searchText;

            try
            {
                //起点から最後まで調べる
                for (int index = selectedNode; treeViewParts.control.Nodes.Count > index; ++index)
                {
                    for (int index2 = selectedNodeNode; treeViewParts.control.Nodes[index].Nodes.Count > index2; ++index2)
                    {
                        if (true == treeViewParts.control.Nodes[index].Nodes[index2].Text.Contains(searchText))
                        {
                            //選択する
                            treeViewParts.control.SelectedNode = treeViewParts.control.Nodes[index].Nodes[index2];
                            //フォーカス
                            //treeViewParts.Focus();
                            //スクロールで移動
                            selectedNode = index;
                            selectedNodeNode = index2;

                            beforeHitNode = treeViewParts.control.Nodes[index].Nodes[index2];
                            //スクロールで移動
                            treeViewParts.control.SelectedNode.EnsureVisible();
                            return;
                        }
                    }
                
                }
                //見つからないのならば初期化
                selectedNode = 0;
                selectedNodeNode = 0;

                treeViewParts.control.SelectedNode = treeViewParts.control.Nodes[0];
                //treeViewParts.Focus();
                //スクロールで移動
                treeViewParts.control.SelectedNode.EnsureVisible();
            }
            catch { ;}
        }

        public void WriteBoardList(TreeViewParts treeViewParts, string str, string boardType)
        {
            try
            {
                List<BoardGroup> group_list = new List<BoardGroup>();
                BoardGroup current_group = null;
                string[] rows = str.Split(new char[] { '\r', '\n' });
                Match groupMatch;
                Match boardMatch;

                foreach (string line in rows.Where(a => a.Length > 0))
                {
                    if ((boardType.Equals("2ch") == true) ||
                        (boardType.Equals("2chsc") == true) ||
                        (boardType.Equals("open2ch") == true) ||
                        (boardType.Equals("next2ch") == true) ||
                        (boardType.Equals("jikkyo") == true))
                    {
                        groupMatch = GROUP_REGEXP.Match(line);
                        boardMatch = BOARD_REGEXP.Match(line);
                    }
                    else if (boardType.Equals("shizu") == true)
                    {
                        groupMatch = GROUP_REGEXP_SHIZU.Match(line);
                        boardMatch = BOARD_REGEXP_SHIZU.Match(line);
                    }
                    else if (boardType.Equals("blogban") == true)
                    {
                        groupMatch = GROUP_REGEXP_BLOGBAN.Match(line);
                        boardMatch = BOARD_REGEXP_BLOGBAN.Match(line);
                    }
                    else if (boardType.Equals("vip2ch") == true)
                    {
                        groupMatch = GROUP_REGEXP_VIP2CH.Match(line);
                        boardMatch = BOARD_REGEXP_VIP2CH.Match(line);
                    }
                    else if (boardType.Equals("machibbs") == true)
                    {
                        groupMatch = GROUP_REGEXP_MACHIBBS.Match(line);
                        boardMatch = BOARD_REGEXP_MACHIBBS.Match(line);
                    }
                    else
                    {
                        groupMatch = GROUP_REGEXP.Match(line);
                        boardMatch = BOARD_REGEXP.Match(line);
                    }



                    if (groupMatch.Success == true)
                    {
                        //まちBBSにはあらかじめグループを作る
                        if (boardType.Equals("machibbs") == true)
                        {
                            string group_name = "地域";
                            current_group = new BoardGroup(group_name);
                            group_list.Add(current_group);
                        }
                        else
                        {
                            string group_name = groupMatch.Groups[1].Value;
                            current_group = new BoardGroup(group_name);
                            group_list.Add(current_group);
                        }
                    }
                    else if (boardMatch.Success == true)
                    {
                        if (group_list == null) continue;

                        string board_url = "";
                        string board_name;
                        //それぞれに合ったアドレスを形成する
                        if (boardType.Equals("shizu") == true)
                        {
                            int size = boardMatch.Groups[1].Value.Length;
                            board_url = "http://shizu.0000.jp/" + boardMatch.Groups[1].Value.Substring(2, size - 2 - 11);
                            board_name = boardMatch.Groups[2].Value;
                        }
                        else if (boardType.Equals("vip2ch") == true)
                        {
                            board_url = boardMatch.Groups[1] + "vip2ch.com" + boardMatch.Groups[2];
                            board_name = boardMatch.Groups[3].Value;
                        }
                        else if (boardType.Equals("machibbs") == true)
                        {
                            int size = boardMatch.Groups[1].Value.Length;
                            board_url = boardMatch.Groups[1].Value.Substring(0, size - 2);
                            board_name = boardMatch.Groups[2].Value;
                        }
                        else
                        {
                            board_url = boardMatch.Groups[1].Value;
                            board_name = boardMatch.Groups[2].Value;
                        }
                        if (board_url.StartsWith("/cdn-cgi/l/email-protection") == true) continue;
                        if (Util.BoardUrlCheck(board_url) == false) continue;

                        string board_id = Util.BoardUrlToBoardID(board_url);
                        if ((board_id == null) || (board_id.Length == 0)) continue;
                        string board_type = Util.BoardUrlToBoardTypeName(board_url);

                        Board board = new Board(board_url, board_name);
                        BoardDataBase.RegisterName(board_url, board_name);
                        BoardDataBase.RegisterUrl(board_type, board_id, board_url);
                        if (current_group != null)
                            current_group.Push(board);
                    }
                }
                foreach (BoardGroup btemp in group_list)
                {
                    if (btemp.list.Count == 0)
                    {
                        group_list.Remove(btemp);
                        break;
                    }
                }

                //描画を止める
                this.mutex.WaitOne();
                this.WritingFlag = false;
                this.mutex.ReleaseMutex();

                treeViewParts.control.Nodes.Clear();
                treeViewParts.control.BeginUpdate();

                int kougox = 0;
                int numx = 0;
                foreach (BoardGroup group in group_list)
                {
                    treeViewParts.control.Nodes.Add(new TreeNode(group.name));

                    int numxx = 0;
                    int kougoxx = 0;
                    foreach (Board board in group.list)
                    {
                        TreeNode _ParentNode = treeViewParts.control.Nodes[treeViewParts.control.Nodes.Count - 1];

                        _ParentNode.Nodes.Add(board.url, board.title);

                        numxx += 1;
                        kougoxx += 1;
                    }
                    numx += 1;
                    kougox += 1;

                }

                treeViewParts.control.EndUpdate();

                //描画を再開
                this.mutex.WaitOne();
                this.WritingFlag = true;
                this.mutex.ReleaseMutex();

                treeViewParts.control.Invalidate();

                current_group = null;
                foreach (BoardGroup boardgroup in group_list)
                {
                    boardgroup.list.Clear();
                }
                group_list.Clear();
            }
            catch { ;}
        }

        public void WriteFavoriteBoardList(TreeViewParts treeViewParts)
        {
            try
            {
                //描画を停止
                this.mutex.WaitOne();
                this.WritingFlag = false;
                this.mutex.ReleaseMutex();

                treeViewParts.control.Nodes.Clear();
                treeViewParts.control.Enabled = false;
                treeViewParts.control.BeginUpdate();
                //treeViewParts.control.SuspendLayout();

                foreach (FavoriteBoardIndex board in FavoriteBoardManager.favoriteBoardList)
                {
                    treeViewParts.control.Nodes.Add(board.boardUrl, board.boardName);
                }

                //treeViewParts.control.ResumeLayout();
                treeViewParts.control.EndUpdate();
                treeViewParts.control.Enabled = true;

                //描画を再開
                this.mutex.WaitOne();
                this.WritingFlag = true;
                this.mutex.ReleaseMutex();
            }
            catch { ;}
        }

        public void WriteCountryBoardList(TreeViewParts treeViewParts, string str)
        {
            string[] rows2 = str.Split(new char[] { '\r', '\n' });

            //描画を停止
            this.mutex.WaitOne();
            this.WritingFlag = false;
            this.mutex.ReleaseMutex();
            
            treeViewParts.control.Nodes.Clear();
            //treeViewParts.control.Enabled = false;
            treeViewParts.control.BeginUpdate();
            //treeViewParts.control.SuspendLayout();

            TreeNode _ParentNode = null;
            foreach (string line in rows2.Where(a => a.Length > 0))
            {
                if (line.StartsWith("*****"))
                {
                    treeViewParts.control.Nodes.Add(line.Substring(5));
                    _ParentNode = treeViewParts.control.Nodes[treeViewParts.control.Nodes.Count - 1];

                    continue;
                }
                string[] item = line.Split(new char[] { ',' });
                _ParentNode.Nodes.Add(item[1], item[0]);

            }
            
            //treeViewParts.control.ResumeLayout();
            treeViewParts.control.EndUpdate();
            //treeViewParts.control.Enabled = true;
            
            //描画を再開
            this.mutex.WaitOne();
            this.WritingFlag = true;
            this.mutex.ReleaseMutex();
        }

        public void WriteScreeningCountryBoardList(TreeViewParts treeViewParts, List<stringstring> strstrList)
        {
            //描画を停止
            this.mutex.WaitOne();
            this.WritingFlag = false;
            this.mutex.ReleaseMutex();

            treeViewParts.control.Nodes.Clear();
            //treeViewParts.control.Enabled = false;
            treeViewParts.control.BeginUpdate();
            //treeViewParts.control.SuspendLayout();

            TreeNode _ParentNode = null;
            foreach (stringstring line in strstrList)
            {
                if (line.data1.StartsWith("*****"))
                {
                    treeViewParts.control.Nodes.Add(line.data1.Substring(5));
                    _ParentNode = treeViewParts.control.Nodes[treeViewParts.control.Nodes.Count - 1];

                    continue;
                }
                _ParentNode.Nodes.Add(line.data2, line.data1);
            }

            //treeViewParts.control.ResumeLayout();
            treeViewParts.control.EndUpdate();
            //treeViewParts.control.Enabled = true;

            //描画を再開
            this.mutex.WaitOne();
            this.WritingFlag = true;
            this.mutex.ReleaseMutex();
        }
    }
}