﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;

namespace nispi.controlclass
{
    class ToolStripButtonParts
    {
        public ToolStripButton control;

        public ToolStripButtonParts()
        {
            control = new ToolStripButton();
            this.control.DisplayStyle = ToolStripItemDisplayStyle.Image;
            //control.Image = new Bitmap(Image.FromFile("analysisall.png"));
            this.control.ImageTransparentColor =  Color.Magenta;
        }
        public event EventHandler Click
        {
            add
            {
                this.control.Click += value;
            }
            remove
            {
                this.control.Click -= value;
            }
        }
        public Image Image
        {
            set
            {
                this.control.Image = value;
            }
            get
            {
                return this.control.Image;
            }
        }
        public string Name
        {
            set
            {
                this.control.Name = value;
            }
            get
            {
                return this.control.Name;
            }
        }
        public string Text
        {
            set
            {
                this.control.Text = value;
            }
            get
            {
                return this.control.Text;
            }
        }
        public Size Size
        {
            set
            {
                this.control.Size = value;
            }
            get
            {
                return this.control.Size;
            }
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class ToolStripButtonPartsManager
    {
        public static Stack<ToolStripButtonParts> tabPageStack = new Stack<ToolStripButtonParts>();
        public static Mutex mutex = new Mutex(false, "ToolStripButtonPartsManager");
     
        public static ToolStripButtonParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new ToolStripButtonParts());

            ToolStripButtonParts tabPage = tabPageStack.Pop();
            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(ToolStripButtonParts tabPage)
        {
            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }
    }
}
