﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;



namespace nispi.controlclass
{
    class SplitContainerParts:ControlBase
    {
        public SplitContainer control;

        public SplitContainerParts()
        {
            control = new SplitContainer();
            this.control.Location = new Point(0, 0);
            this.control.Margin = new Padding(0);
            this.control.Name = "control";
            //this.control.Left = 0;
            //this.control.Top = 0;
            this.controlBase = (System.Windows.Forms.Control)control;
        }

        public void Panel1ControlsRemove(ControlBase targetControlBase)
        {
            this.control.Panel1.Controls.Remove(targetControlBase.controlBase);
        }
        
        public void Panel2ControlsRemove(ControlBase targetControlBase)
        {
            this.control.Panel2.Controls.Remove(targetControlBase.controlBase);
        }
        
        public void SetHorizontal()
        {
            this.control.Orientation = Orientation.Horizontal;
        }
        
        public void SetVertical()
        {
            this.control.Orientation = Orientation.Vertical;
        }
        
        public void SetFixedPanel(int num)
        {
            if (num == 1)
                this.control.FixedPanel = FixedPanel.Panel1;
            else if (num == 2)
                this.control.FixedPanel = FixedPanel.Panel2;
        }
        
        public int SplitterDistance
        {
            set
            {
                if (value > 0)
                    this.control.SplitterDistance = value;
            }
            get
            {
                return this.control.SplitterDistance;
            }
        }
        public int Panel2_Width
        {
            get
            {
                return this.control.Panel2.Width;
            }
        }
        public int Panel2_Height
        {
            get
            {
                return this.control.Panel2.Height;
            }
        }
        public void AddToPanel1(ControlBase targetControlBase)
        {
            this.control.Panel1.Controls.Add(targetControlBase.controlBase);
        }
        
        public void AddToPanel2(ControlBase targetControlBase)
        {
            this.control.Panel2.Controls.Add(targetControlBase.controlBase);
        }

        public event EventHandler Panel1_Resize
        {
            add
            {
                this.control.Panel1.Resize += value;
            }
            remove
            {
                this.control.Panel1.Resize -= value;
            }
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class SplitContainerPartsManager
    {
        public static Stack<SplitContainerParts> tabPageStack = new Stack<SplitContainerParts>();
        public static Mutex mutex = new Mutex(false, "SplitContainerPartsManager");

        public static SplitContainerParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new SplitContainerParts());

            SplitContainerParts tabPage = tabPageStack.Pop();

            float scaledFloat = Scale.GetScaledFloat();

            tabPage.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);

            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(SplitContainerParts tabPage)
        {
            tabPage.ResetControlBase();

            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }
    }
}
