﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    ///

    class SimpleCBoxParts : ControlBase
    {
        private ComboBox control;

        public SimpleCBoxParts()
        {
            //コンボボックス
            control = new ComboBox();

            control.DropDownStyle = ComboBoxStyle.DropDownList;


            this.controlBase = (System.Windows.Forms.Control)control;
        }

        public void ItemsAdd(string text)
        {
            this.control.Items.Add(text);
        }

        public event EventHandler SelectedIndexChanged
        {
            add
            {
                this.control.SelectedIndexChanged += value;
            }
            remove
            {
                this.control.SelectedIndexChanged -= value;
            }
        }

        public int SelectedIndex
        {
            set
            {
                this.control.SelectedIndex = value;
            }
            get
            {
                return this.control.SelectedIndex;
            }
        }
    }

    class SimpleCBoxPartsManager
    {
        public static Stack<SimpleCBoxParts> buttonStack = new Stack<SimpleCBoxParts>();
        public static Mutex mutex = new Mutex(false, "ThreadView_SimpleCBoxManager");

        public static SimpleCBoxParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new SimpleCBoxParts());

            SimpleCBoxParts buttonParts = buttonStack.Pop();

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(SimpleCBoxParts buttonParts)
        {
            buttonParts.ResetControlBase();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
    }
}