﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

using System.Drawing;

namespace nispi.controlclass
{
    class ListViewPartsManager
    {
        public static LinkedList<ListViewParts> allList = new LinkedList<ListViewParts>();
        public static Stack<ListViewParts> buttonStack = new Stack<ListViewParts>();
        public static Mutex mutex = new Mutex(false, "ListViewPartManager");

        public static ListViewParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new ListViewParts());

            ListViewParts buttonParts = buttonStack.Pop();

            //GUIのリストを作成する
            if (null == allList.Find(buttonParts))
            {
                ChangeOutWard(buttonParts);
                allList.AddLast(buttonParts);
            }

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(ListViewParts buttonParts)
        {
            mutex.WaitOne();

            buttonParts.ResetControl();
            buttonParts.Update();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (ListViewParts parts in allList)
            {
                //parts.SetFont(Const.opt.outWardList.LVFontName, Const.opt.outWardList.LVFontSize);
                parts.Font = Const.opt.outWardList.LVFont;

                parts.columnForeBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVColmunForeColorRed,
                    Const.opt.outWardList.LVColmunForeColorGreen,
                    Const.opt.outWardList.LVColmunForeColorBlue));

                parts.columnBackBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVColmunBackColorRed,
                    Const.opt.outWardList.LVColmunBackColorGreen,
                    Const.opt.outWardList.LVColmunBackColorBlue));

                parts.lVForeColorBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVForeColorRed,
                    Const.opt.outWardList.LVForeColorGreen,
                    Const.opt.outWardList.LVForeColorBlue));

                parts.lVBackColorBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVBackColorRed,
                    Const.opt.outWardList.LVBackColorGreen,
                    Const.opt.outWardList.LVBackColorBlue));

                parts.lVBackColor2Brush = new SolidBrush(Color.FromArgb(
                         255,
                    Const.opt.outWardList.LVBackColor2Red,
                    Const.opt.outWardList.LVBackColor2Green,
                    Const.opt.outWardList.LVBackColor2Blue));

                parts.lVSelectForeColorBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVSelectForeColorRed,
                    Const.opt.outWardList.LVSelectForeColorGreen,
                    Const.opt.outWardList.LVSelectForeColorBlue));
                parts.lVSelectBackColorBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVSelectBackColorRed,
                    Const.opt.outWardList.LVSelectBackColorGreen,
                    Const.opt.outWardList.LVSelectBackColorBlue));
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();

            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard(ListViewParts parts)
        {
            Const.form.mainForm.Invoke((Action)(() => parts.Font = Const.opt.outWardList.LVFont));

            parts.columnForeBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVColmunForeColorRed,
                Const.opt.outWardList.LVColmunForeColorGreen,
                Const.opt.outWardList.LVColmunForeColorBlue));

            parts.columnBackBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVColmunBackColorRed,
                Const.opt.outWardList.LVColmunBackColorGreen,
                Const.opt.outWardList.LVColmunBackColorBlue));

            parts.lVForeColorBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVForeColorRed,
                Const.opt.outWardList.LVForeColorGreen,
                Const.opt.outWardList.LVForeColorBlue));

            parts.lVBackColorBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVBackColorRed,
                Const.opt.outWardList.LVBackColorGreen,
                Const.opt.outWardList.LVBackColorBlue));

            parts.lVBackColor2Brush = new SolidBrush(Color.FromArgb(
                     255,
                Const.opt.outWardList.LVBackColor2Red,
                Const.opt.outWardList.LVBackColor2Green,
                Const.opt.outWardList.LVBackColor2Blue));

            parts.lVSelectForeColorBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVSelectForeColorRed,
                Const.opt.outWardList.LVSelectForeColorGreen,
                Const.opt.outWardList.LVSelectForeColorBlue));
            parts.lVSelectBackColorBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVSelectBackColorRed,
                Const.opt.outWardList.LVSelectBackColorGreen,
                Const.opt.outWardList.LVSelectBackColorBlue));

            parts.BackColor =  Color.FromArgb(
                255,
                Const.opt.outWardList.LVBackColorRed,
                Const.opt.outWardList.LVBackColorGreen,
                Const.opt.outWardList.LVBackColorBlue);

            float scaledFloat = Scale.GetScaledFloat(Const.opt.outWardList.LVFontSize);

            //parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }

        public static void ChangeOutWard2()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (ListViewParts parts in allList)
            {

                parts.columnForeBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVColmunForeColorRed,
                    Const.opt.outWardList.LVColmunForeColorGreen,
                    Const.opt.outWardList.LVColmunForeColorBlue));

                parts.columnBackBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVColmunBackColorRed,
                    Const.opt.outWardList.LVColmunBackColorGreen,
                    Const.opt.outWardList.LVColmunBackColorBlue));

                parts.lVForeColorBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVForeColorRed,
                    Const.opt.outWardList.LVForeColorGreen,
                    Const.opt.outWardList.LVForeColorBlue));

                parts.lVBackColorBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVBackColorRed,
                    Const.opt.outWardList.LVBackColorGreen,
                    Const.opt.outWardList.LVBackColorBlue));

                parts.lVBackColor2Brush = new SolidBrush(Color.FromArgb(
                         255,
                    Const.opt.outWardList.LVBackColor2Red,
                    Const.opt.outWardList.LVBackColor2Green,
                    Const.opt.outWardList.LVBackColor2Blue));

                parts.lVSelectForeColorBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVSelectForeColorRed,
                    Const.opt.outWardList.LVSelectForeColorGreen,
                    Const.opt.outWardList.LVSelectForeColorBlue));
                parts.lVSelectBackColorBrush = new SolidBrush(Color.FromArgb(
                    255,
                    Const.opt.outWardList.LVSelectBackColorRed,
                    Const.opt.outWardList.LVSelectBackColorGreen,
                    Const.opt.outWardList.LVSelectBackColorBlue));
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();

            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }
    }
}