﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;
using System.Linq;

using nispi.Menu;

namespace nispi.controlclass
{
    partial class ListViewParts : ControlBase
    {
        public ListViewEx control;
        
        public BoardViewCommon boardView;
        public List<ThreadData> usingThreadData;
        
        ColumnHeader columnNew = new ColumnHeader();
        ColumnHeader columnNo = new ColumnHeader();
        ColumnHeader columnLog = new ColumnHeader();
        ColumnHeader columnThreadName = new ColumnHeader();
        ColumnHeader columnRes = new ColumnHeader();
        ColumnHeader columnRead = new ColumnHeader();
        ColumnHeader columnNoRead = new ColumnHeader();
        ColumnHeader columnOpenTime = new ColumnHeader();
        ColumnHeader columnThreadSpeed = new ColumnHeader();
        ColumnHeader columnBoardName = new ColumnHeader();

        ColumnHeader[] colHeaderRegValue;

        public Image imageLog;
        public Image imageNew;
        
        //private Color hitItemColor;
        
        public int[] oldItemNumList;
        
        //private ListViewItem hitItem = null;
        

        public ListViewItemParts[] items;

        public int itemSize = 0;

        /// <summary>
        /// 外観に関するデータ
        /// </summary>
        //public OptionControl.ColorSet columnFore = new OptionControl.ColorSet();
        //public OptionControl.ColorSet columnBack = new OptionControl.ColorSet();

        public SolidBrush columnForeBrush;
        public SolidBrush columnBackBrush;

        public SolidBrush lVForeColorBrush;
        
        public SolidBrush lVBackColorBrush;
        public SolidBrush lVBackColor2Brush;

        public SolidBrush lVSelectForeColorBrush;
        public SolidBrush lVSelectBackColorBrush;
        //-----------------------------------------

        public bool ShiftFlag = false;
        public int ShiftFlagBeginNum = -1;

        //コントロール外に出た場合にアクセスを無効にするためのデータメンバ
        private int mouseEnterNum = 0;
        private int mouseDownNum = 0;

        private ToolTipParts toolTipParts;

        public ListViewParts()
        {
            oldItemNumList = new int[0];
            //listView
            control = new ListViewEx();

            ImageList list = new ImageList();
            list.ImageSize = new Size(1, 8);
            control.SmallImageList = list;
            control.Font = Const.opt.outWardList.LVFont;
            //    new Font("Meiryo UI", 10.75F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            control.Location = new Point(0, 27);
            control.Name = "listView1";
            control.Size =
                new Size(Const.form.boardListTabControlParts.Size.Width - 4, Const.form.boardListTabControlParts.Size.Height - 29);
            control.TabIndex = 0;
            control.UseCompatibleStateImageBehavior = false;
            control.View = View.Details;
            control.FullRowSelect = true;

            //control.HideSelection = false;
            control.SelectedIndexChanged += new EventHandler(listViewPart_SelectedIndexChanged);
            control.SizeChanged += new EventHandler(listView_SizeChanged);

            //control.MouseDown += new MouseEventHandler(listView_MouseDown);
            //control.MouseUp += new MouseEventHandler(listView_MouseUp);
            control.MouseUp += new MouseEventHandler(listView_MouseUp);
            control.MouseDoubleClick += new MouseEventHandler(listView_MouseDoubleClick);
            control.MouseMove += new MouseEventHandler(listViewPart_MouseMove);
            control.ColumnClick += new ColumnClickEventHandler(listView_ColumnClick);

            control.KeyDown += new KeyEventHandler(ListView_KeyDown);
            control.KeyUp += new KeyEventHandler(ListView_KeyUp);

            //一度マウス押下してから外に出た場合に無効にする
            control.MouseEnter += new EventHandler(listView_Enter);
            control.MouseDown += new MouseEventHandler(listView_MouseDown);


            imageLog = Resources.logloaded;
            imageNew = Resources.newthread;

            //外観の初期化
            columnForeBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVColmunForeColorRed,
                Const.opt.outWardList.LVColmunForeColorGreen,
                Const.opt.outWardList.LVColmunForeColorBlue));

            columnBackBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVColmunBackColorRed,
                Const.opt.outWardList.LVColmunBackColorGreen,
                Const.opt.outWardList.LVColmunBackColorBlue));

            lVForeColorBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVForeColorRed,
                Const.opt.outWardList.LVForeColorGreen,
                Const.opt.outWardList.LVForeColorBlue));

            lVBackColorBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVBackColorRed,
                Const.opt.outWardList.LVBackColorGreen,
                Const.opt.outWardList.LVBackColorBlue));

            lVBackColor2Brush = new SolidBrush(Color.FromArgb(
                     255,
                Const.opt.outWardList.LVBackColor2Red,
                Const.opt.outWardList.LVBackColor2Green,
                Const.opt.outWardList.LVBackColor2Blue));

            lVSelectForeColorBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVSelectForeColorRed,
                Const.opt.outWardList.LVSelectForeColorGreen,
                Const.opt.outWardList.LVSelectForeColorBlue));
            lVSelectBackColorBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVSelectBackColorRed,
                Const.opt.outWardList.LVSelectBackColorGreen,
                Const.opt.outWardList.LVSelectBackColorBlue));
            ///------------------------------------------------------------

            //オーナードローの３つ
            control.OwnerDraw = true;
            control.DrawColumnHeader += new DrawListViewColumnHeaderEventHandler(control_DrawColumnHeader);
            control.DrawItem += new DrawListViewItemEventHandler(control_DrawItem);
            control.DrawSubItem += new DrawListViewSubItemEventHandler(control_DrawSubItem);


            this.controlBase = (System.Windows.Forms.Control)control;

            //１行のみにする
            this.control.MultiSelect = true;// false;


            // 仮想モードON
            control.VirtualMode = true;
            // Item数設定
            control.VirtualListSize = 1000;
            // 必須：描画に必要なListViewItemを返すイベント追加
            control.RetrieveVirtualItem += new RetrieveVirtualItemEventHandler(listView_RetrieveVirtualItem);


            // 列（コラム）ヘッダの作成
            columnNew.Text = "ﾆｭｰ";
            columnNew.Width = 40;
            columnNo.Text = "No.";
            columnNo.Width = 40;
            columnLog.Text = "ﾛｸﾞ";
            columnLog.Width = 40;
            columnThreadName.Text = "スレッド名";
            columnThreadName.Width = 200;
            columnRes.Text = "レス";
            columnRes.Width = 40;
            columnRead.Text = "既読";
            columnRead.Width = 40;
            columnNoRead.Text = "未読";
            columnNoRead.Width = 40;
            columnOpenTime.Text = "作成日時";
            columnOpenTime.Width = 140;
            columnThreadSpeed.Text = "speed";
            columnThreadSpeed.Width = 60;
            columnBoardName.Text = "板名";
            columnBoardName.Width = 120;

            //colHeaderRegValue = {
			//	columnNew, columnNo, columnLog, columnThreadName,
			//	columnRes, columnRead, columnNoRead, columnOpenTime, columnThreadSpeed,columnBoardName};
            control.Columns.Add(columnNew);
            control.Columns.Add(columnNo);
            control.Columns.Add(columnLog);
            control.Columns.Add(columnThreadName);
            control.Columns.Add(columnRes);
            control.Columns.Add(columnRead);
            control.Columns.Add(columnNoRead);
            control.Columns.Add(columnOpenTime);
            control.Columns.Add(columnThreadSpeed);
            control.Columns.Add(columnBoardName);
            //control.Columns.AddRange(colHeaderRegValue);
         
            control.PreviewKeyDown += new PreviewKeyDownEventHandler(control_PreviewKeyDownEvent);

            //ツールチップ
            toolTipParts = ToolTipPartsManager.Pop();            
            control.ItemMouseHover += new ListViewItemMouseHoverEventHandler(control_ItemMouseHover);
            control.MouseLeave += new EventHandler(control_MouseLeave);
        }

        private void control_PreviewKeyDownEvent(object sender, PreviewKeyDownEventArgs e)
        {
            if ((e.Control == true) && (e.KeyCode == Keys.W))
            {
                int selectIndex = Const.form.boardListTabControlParts.SelectedIndex;

                if (selectIndex == 0)
                {
                    return;
                }
                MainFormConst.boardListTabMain.view_list[selectIndex].Dispoose();
            }
            else if ((e.Control == true) && (e.KeyCode == Keys.R))
            {
                int selectIndex = Const.form.boardListTabControlParts.SelectedIndex;

                if (selectIndex == 0)
                {
                    return;
                }
                MainFormConst.boardListTabMain.view_list[selectIndex].reload();
            }
            else if ((e.Control == true) && (e.KeyCode == Keys.Q))
            {
                int selectIndex = Const.form.boardListTabControlParts.SelectedIndex;

                if (selectIndex == 0)
                {
                    return;
                }
                ContextMenuControls.boardListTabMenu.boardListTabEvent.menuItemCloseAllTab_Click(new object(), new EventArgs());
            }
            else if ((e.Control == true) && (e.KeyCode == Keys.F))
            {
                int selectIndex = Const.form.boardListTabControlParts.SelectedIndex;

                if (selectIndex == 0)
                {
                    return;
                }
                ContextMenuControls.boardListTabMenu.boardListTabEvent.menuItemAddFavorite_Click(new object(), new EventArgs());
            }

            else if ((e.Control == true) && (e.KeyCode == Keys.D))
            {
                int selectIndex = Const.form.boardListTabControlParts.SelectedIndex;

                if (selectIndex != 0)
                {
                    return;
                }
                ContextMenuControls.listViewMenu.listViewPartMenuEvent.menuItemDeleteLog_Click(new object(), new EventArgs());
            }
            else if (e.KeyCode == Keys.N)
            {
                SearchListViewNbutton();
            }

        }

        public void ResetControl()
        {
            //this.control.Anchor = AnchorStyles.None;
            //this.control.Dock = DockStyle.None;
            //this.Location = new Point(1, 1);
        }

        public int[] GetSelectedIndices()
        {
            List<int> list = new List<int>();
            foreach (int num in this.control.SelectedIndices)
            {
                list.Add(num);
            }
            return list.ToArray();
        }
        public void BeginUpdate()
        {
            this.control.BeginUpdate();
        }
        public void EndUpdate()
        {
            this.control.EndUpdate();
        }

        public void GetFocus(ListViewEx listViewEx)
        {
            if (Const.form.mainForm.ContainsFocus == true)
            {
                listViewEx.Focus();
            }
        }
    }
}
