/*# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Runtime.InteropServices;

using nispi.Menu;

namespace nispi
{
    class MyWebBrowser : System.Windows.Forms.WebBrowser
    {
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams parms = base.CreateParams;
                parms.Style |= 0x800000;  // Turn on WS_BORDER
                return parms;
            }
        }
    }

    static class PopUpManager
    {
        public static int lastTime;
        public static string openNum;
        public static string openDatUrl;
        public static bool openFlag;

        public static void Setup()
        {
            lastTime = 0;
            openNum = "";
            openDatUrl = "";
            openFlag = false;
        }
    }

    class BrowserParts
    {
        public MyWebBrowser control = new MyWebBrowser();

        public static MainForm form = null;

        private ThreadViewCommon threadView;
        //}EXɓ镶
        string mouseDownText = "";
        
        public bool nonTextMenuOn;
        public bool textMenuOn;

        public BrowserParts()
        {
            control.Anchor = (AnchorStyles)
                ((AnchorStyles.Top)
                | (AnchorStyles.Bottom)
                | (AnchorStyles.Left)
                | (AnchorStyles.Right));
            control.Location = new Point(1, 27);
            control.Name = "webBrowser1";
            control.TabIndex = 0;
            control.ScrollBarsEnabled = true;
            control.Font = new Font("Meiryo UI", 10.75F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            control.ScriptErrorsSuppressed = true;

            control.IsWebBrowserContextMenuEnabled = false;

            control.Document.Window.Name = "Basic";

            control.Document.MouseMove += new HtmlElementEventHandler(Document_MouseMove);

            control.Document.MouseDown += new HtmlElementEventHandler(Document_MouseDown);

            control.Document.MouseUp += new HtmlElementEventHandler(Document_MouseUp);
        }

        public bool CheckConsistency()
        {
            try
            {
                int index = Const.form.threadListTabControlParts.control.Controls.Count;
                this.threadView = ViewMediator.threadListTabMain.viewList[index];
                return true;
            }
            catch
            {
                return false;
            }
        }

        //TCY//bsO
        public Size Size
        {
            set
            {
                this.control.Size = value;
            }
            get
            {
                return this.control.Size;
            }
        }
        //hLg
        public HtmlDocument Document
        {
            /*set
            {
                this.control.Document = value;
            }*/
            get
            {
                return this.control.Document;
            }
        }
        public bool AllowNavigation
        {
            set
            {
                this.control.AllowNavigation = value;
            }
            get
            {
                return this.control.AllowNavigation;
            }
        }
        public void BrowserClear()
        {
            try
            {
                if (control.Document != null)
                {
                    control.Document.OpenNew(true);
                }
                else
                {
                    control.Navigate("about:blank");
                }
            }
            catch { ;}
        }
        //hLgJ
        public void OpenNew(bool type)
        {
            this.control.Document.OpenNew(type);
        }
        public void Navigate(string text)
        {
            this.control.Navigate(text);
        }
        public void Write(string text)
        {
            this.control.Document.Write(text);
        }
        public Point GetScrollRectangle()
        {
            HtmlElement body = this.control.Document.Body;
            Point scrollpos = new Point(body.ScrollRectangle.X, body.ScrollRectangle.Y);
            return scrollpos;
        }
        public ThreadViewCommon threadViewProperty
        {
            set
            {
                this.threadView = value;
            }
        }

        #region MouseMove
        //hLg}EXƂB|bvAbv
        public void Document_MouseMove(object sender, HtmlElementEventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            HtmlDocument htmlDocument = (HtmlDocument)sender;

            //ɂ|bvAbvEBhEJ
            HtmlElement overElement = htmlDocument.GetElementFromPoint(e.MousePosition);
            string text = "";
            string href = "";
            HtmlUtil.GetClickTagInfo(overElement, ref href, ref text);

            //|bvAbvEBhẼRg[ꍇ
            if (true == htmlDocument.Window.Name.Equals("PopUp"))
            {
                System.Diagnostics.Debug.WriteLine("focus1");
                GetFocus(htmlDocument);
            }
            else
            {
                System.Diagnostics.Debug.WriteLine("focus2");
                if (htmlDocument.Focused == false)
                {
                    System.Diagnostics.Debug.WriteLine("focus3");
                    //|bvAbvEBhEꍇ͖ŏ
                    if (ViewMediator.htmlPopUpWindowWidget.popUpList.Count > 0)
                    {
                        System.Diagnostics.Debug.WriteLine("focus");
                        /* Xԍ */
                        if (0 == href.IndexOf("javascript:void(0);#res", 0))
                        {
                            string number = text.Remove(0, 2);
                            string datUrl = href.Remove(0, 23 + number.Length + 1);
                            if ((false == PopUpManager.openNum.Equals(number)) || (number.Equals("0") == true))
                            {
                                ViewMediator.htmlPopUpWindowWidget.RemoveAllPopUp();
                                GetFocus(htmlDocument);
                            }
                        }
                        else if (href.Length == 0)
                        {
                            ViewMediator.htmlPopUpWindowWidget.RemoveAllPopUp();
                            GetFocus(htmlDocument);
                        }
                    }
                    //|bvAbvEBhEB
                    else
                    {
                        GetFocus(htmlDocument);
                    }
                }
            }

            if ((text != null) && (text.Length > 1))
            {
                System.Diagnostics.Debug.WriteLine("focus4");
                //AJ[̏ꍇ
                if (text.IndexOf(">>") == 0)
                {
                    /* Xԍ */
                    if (0 == href.IndexOf("javascript:void(0);#res", 0))
                    {
                        string number = text.Remove(0, 2);
                        string datUrl = href.Remove(0, 23 + number.Length + 1);

                        if (true == PopUpManager.openNum.Equals(number))
                        {
                        }
                        else
                        {
                            PopUpManager.openDatUrl = datUrl;
                            PopUpManager.openNum = number;
                            PopUpManager.openFlag = true;
                            PopUpManager.lastTime = System.Environment.TickCount & int.MaxValue;
                            System.Diagnostics.Debug.WriteLine("new:" + number);

                            ViewMediator.PopUpWindow(Cursor.Position, threadView, datUrl, number);
                        }
                    }
                }
                else if (text.IndexOf("ID") == 0)
                {
                    /* Xԍ */
                    if (0 == href.IndexOf("javascript:void(0);#ID:", 0))
                    {
                        string id = text;
                        string datUrl = href.Remove(0, 23 + id.Length + 1);

                        System.Diagnostics.Debug.WriteLine("new:" + id);
                        if (true == PopUpManager.openNum.Equals(id))
                        {
                        }
                        else
                        {
                            PopUpManager.openNum = id;
                            ViewMediator.PopUpWindow(Cursor.Position, threadView, datUrl, id, "idFromID");
                        }
                    }
                }
                else if (text.IndexOf("ڽ") == 0)
                {
                    /* Xԍ */
                    if (0 == href.IndexOf("javascript:void(0);#POPNUM:", 0))
                    {
                        string temp = href.Remove(0, 27);
                        string[] temp2 = temp.Split('#');
                        string number = temp2[1];
                        string datUrl = temp2[2];

                        System.Diagnostics.Debug.WriteLine("new:" + number);

                        if (true == PopUpManager.openNum.Equals(number))
                        {
                        }
                        else
                        {
                            PopUpManager.openNum = number;
                            ViewMediator.PopUpWindow(Cursor.Position, threadView, datUrl, number, "POPNUM");
                        }
                    }
                }
            }
            else
            {
                PopUpManager.openNum = "0";
            }
        }
        public void GetFocus(HtmlDocument htmlDocument)
        {
            //tH[ԏłꍇB
            if (MapPopUpForm.popUp.Visible == true)
            {
                if (MapPopUpForm.popUp.ContainsFocus == true)
                    htmlDocument.Focus(); ;
            }
            else if (form.ContainsFocus == true)
            {
                System.Diagnostics.Debug.WriteLine("focus");
                //ViewMediator.htmlPopUpWindowWidget.RemoveAllPopUp();
                htmlDocument.Focus();

            }
        }
        #endregion

        #region MouseDown
        public void Document_MouseDown(object sender, HtmlElementEventArgs e)
        {
            string href = "";
            mouseDownText = "";
            HtmlElement clickedElement = ((HtmlDocument)sender).GetElementFromPoint(e.MousePosition);
            HtmlUtil.GetClickTagInfo(clickedElement, ref href, ref mouseDownText);
        }
        #endregion

        #region MouseUp
        public void Document_MouseUp(object sender, HtmlElementEventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string selectText = "";
            HtmlElement clickedElement = ((HtmlDocument)sender).GetElementFromPoint(e.MousePosition);
            /*<a>̃AhX*/
            string href = "";
            /*<a></a>̊Ԃ̃eLXg*/
            string text = "";

            //<a>^Oo
            HtmlUtil.GetClickTagInfo(clickedElement, ref href, ref text);
            HtmlUtil.GetSelectText(ref selectText, this.control);

            /* ENbNꂽ */
            if (0 == e.MouseButtonsPressed.CompareTo(MouseButtons.Right))
            {
                /*IꂽeLXgꍇ*/
                if ((selectText != null) && (selectText.Length > 0))
                {
                    textMenu.OpenTextMenu(control, e.MousePosition, selectText);
                    return;
                }
                /* ttpŎn܂AhX'h'⊮ */
                if (0 == text.IndexOf("ttp://", 0))
                {
                    text = 'h' + text;
                }
                /* AhXhttp:// Ŏn܂ꍇ*/
                if (text.IndexOf("http://") == 0)
                {
                    addressMenu.OpenAddressMenu(control, e.MousePosition, text);
                    return;
                }
                /* ">>"Ŏn܂鎞 */
                else if (text.IndexOf(">>") == 0)
                {
                    /* XԍNbNꍇ */
                    if (0 == href.IndexOf("javascript:void(0);#res", 0))
                    {
                        numberMenu.OpenNumberMenu(control, e.MousePosition, text);
                        return;
                    }
                }
                //͑ł͎gȂ悤ɂ
                else if ((text.Length == 0) && (href.Length == 0))
                {
                    nonTextMenu.OpenNonTextMenu(control, e.MousePosition);
                }
            }
            /* NbNꂽ */
            else if (0 == e.MouseButtonsPressed.CompareTo(MouseButtons.Left))
            {
                //{^ɃNł͂Ȃꍇ
                if ((mouseDownText == null) || (mouseDownText.Length == 0))
                {
                    return;
                }
                //ttpŎn܂AhX'h'⊮
                if (0 == text.IndexOf("ttp://", 0))
                {
                    text = 'h' + text;
                }
                //AhXhttp:// Ŏn܂ꍇɃuEUŊJ*/
                if (text.IndexOf("http://") == 0)
                {
                    System.Diagnostics.Process.Start(text);
                    return;
                }
                //">>"Ŏn܂鎞̓y[Wړ */
                /*else if (text.IndexOf(">>") == 0)
                {
                    HtmlUtil.MoveToResNum((HtmlDocument)sender, text);
                    return;
                }*/
                else if (0 == href.IndexOf("javascript:void(0);#ANARYNUM", 0))
                {
                    string[] item = href.Split('#');
                    string num = item[2];
                    string datUrl = item[3];

                    ViewMediator.PopUpWindow(Cursor.Position, threadView, datUrl, num);//, "idFromID");
                }

                else if (0 == href.IndexOf("javascript:void(0);#WORD#", 0))
                {
                    string data = href.Substring(25, href.Length - 25);
                    ViewMediator.PopUpWindow(Cursor.Position, threadView, threadView.datUrl, data, "WORD");
                    return;
                }
            }
            /* ȊONbNꂽ */
            else
            {
                return;
            }
            /* XԍNbNꍇ */
            if (0 == href.IndexOf("javascript:void(0);#num", 0))
            {
                text = ">>" + text;
                numberMenu.OpenNumberMenu(control, e.MousePosition, text);
                return;
            }
        }
        #endregion
    }
}