﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    class ButtonParts : ControlBase
    {
        private Button control;

        public ButtonParts()
        {
            control = new Button();
            controlBase = (System.Windows.Forms.Control)control;

            ///control.BackgroundImageLayout = ImageLayout.Stretch;
            //control.FlatStyle = FlatStyle.System;
        }

        public Image Image
        {
            set
            {
                this.control.Image = value;
            }
            get
            {
                return this.control.Image;
            }
        }

        public void SetBitMap(string fileName)
        {
            Bitmap bitmap = new Bitmap(Image.FromFile(fileName));
            //bitmap.MakeTransparent(Color.White);
            control.Image = bitmap;
            //bitmap.Dispose();
        }
        public void ResetControl()
        {
            if (control.Image != null)
            {
                control.Image.Dispose();
                control.Image = null;
            }
        }
    }

    class ButtonPartsManager
    {
        public static LinkedList<ButtonParts> allFormList = new LinkedList<ButtonParts>();
        public static Stack<ButtonParts> buttonStack = new Stack<ButtonParts>();
        public static Mutex mutex = new Mutex(false, "ButtonPartsManager");

        public static ButtonParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new ButtonParts());

            ButtonParts buttonParts = buttonStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(buttonParts))
            {
                ChangeOutWard(buttonParts);
                allFormList.AddLast(buttonParts);
            }

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(ButtonParts buttonParts)
        {
            buttonParts.ResetControlBase();
            buttonParts.ResetControl();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
        public static void ChangeOutWard()
        {
            return;
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (ButtonParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardForm.FormBackColorRed,
                    Const.opt.outWardForm.FormBackColorGreen,
                    Const.opt.outWardForm.FormBackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }
        public static void ChangeOutWard(ButtonParts parts)
        {
            //return;
            /*parts.ForeColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardForm.FormBackColorRed,
                Const.opt.outWardForm.FormBackColorGreen,
                Const.opt.outWardForm.FormBackColorBlue);*/

            float scaledFloat = Scale.GetScaledFloat();

            parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }
    }
}