﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;

using nispi.controlclass;
namespace nispi
{
    class CalendarInBoardView
    {
        private static CalendarCommon calendarCommon = null;
        public static BoardViewTimeExtraction bvExtraction;
        public static string boardUrl;
        //public static Button button;
        public static int containKakoLog;

        public CalendarInBoardView(int _containKakoLog, Point point, string _boardUrl, BoardViewTimeExtraction _bvExtraction)
        {
            if (calendarCommon == null)
                calendarCommon = new CalendarCommon(calendar_DateSelected, calendar_LostFocus);

            boardUrl = _boardUrl;
            bvExtraction = _bvExtraction;
            //button = buttonParts.GetControl();
            containKakoLog = _containKakoLog;
            
            calendarCommon.CalendarShow(point);
        }

        public void calendar_DateSelected(object sender, DateRangeEventArgs e)
        {
            Const.form.mainForm.SetWaitCursor();

            DateTime dt = e.Start.Date;

            bvExtraction.SetData(boardUrl, containKakoLog, 0, dt.Year.ToString() + "_" + dt.Month.ToString() + "_" + dt.Day.ToString());

            Const.form.mainForm.ReSetWaitCursor();

            calendarCommon.popUp.Hide();
            calendarCommon.calendar.Hide();
            bvExtraction.boardView.bvTimeExtraction.pinPointJPDate = /*button.Text =*/ dt.Year.ToString().Substring(2, 2) + "年" + dt.Month.ToString() + "月" + dt.Day.ToString() + "日";
        }

        public void calendar_LostFocus(object sender, EventArgs e)
        {
            calendarCommon.popUp.Hide();
            calendarCommon.calendar.Hide();
        }
    }
}