﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

//参考ページ：http://msdn.microsoft.com/ja-jp/library/system.windows.forms.monthcalendar(v=vs.110).aspx

namespace nispi
{
    class CalendarCommon
    {
        public MonthCalendar calendar;
        public Form popUp;

        public CalendarCommon(DateRangeEventHandler calendar_DateSelected, EventHandler calendar_LostFocus)
        {
            popUp = new Form();
            popUp.StartPosition = FormStartPosition.Manual;
            popUp.Hide();

            // Create the calendar.
            calendar = new MonthCalendar();
            calendar.DateSelected += new DateRangeEventHandler(new DateRangeEventHandler(calendar_DateSelected));
            calendar.LostFocus += new EventHandler(new EventHandler(calendar_LostFocus));
            calendar.Hide();

            //ウィンドウの外に出ないように調節する
            if ((popUp.Size.Height + popUp.Location.Y) > Const.DisplayY)
            {
                popUp.Location =
                    new Point(popUp.Location.X,
                    popUp.Location.Y - ((popUp.Size.Height + popUp.Location.Y) - Const.DisplayY));

                if (popUp.Size.Height > Const.DisplayY)
                {
                    popUp.Location = new Point(popUp.Location.X, 0);
                    popUp.Size = new Size(popUp.Size.Width, Const.DisplayY);
                }
            }
            if ((popUp.Size.Width + popUp.Location.X) > Const.DisplayX)
            {
                popUp.Location =
                    new Point(popUp.Location.X - ((popUp.Size.Width + popUp.Location.X) - Const.DisplayX),
                    popUp.Location.Y);
            }

            popUp.ShowInTaskbar = false;
            popUp.ShowIcon = false;
            popUp.FormBorderStyle = FormBorderStyle.None;
            popUp.Padding = new Padding(0, 0, 0, 0);

            // Set the calendar location.
            calendar.Location = new Point(8, 8);
            // Set the maximum visible date on the calendar to 12/31/2010.
            calendar.MaxDate = DateTime.Now;
            // Set the minimum visible date on calendar to 12/31/2010.
            calendar.MinDate = new System.DateTime(1997, 1, 1, 0, 0, 0, 0);
            // Only allow 21 days to be selected at the same time.
            calendar.MaxSelectionCount = 1;
            // Set the calendar to move one month at a time when navigating using the arrows.
            calendar.ScrollChange = 1;
            // Do not show the "Today" banner.
            calendar.ShowToday = true;
            // Do not circle today's date.
            calendar.ShowTodayCircle = true;
            // Show the week numbers to the left of each week.
            //calendar.ShowWeekNumbers = true;
            calendar.CalendarDimensions = new System.Drawing.Size(1, 1);

            //alendar.Show();
            popUp.Controls.Add(calendar);

            //popUp.Size = new Size(220, 166);//100% 
            //popUp.Size = new Size(273, 201);//125% 
            //popUp.Size = new Size(319, 238);//150% 
            //popUp.Show();
            popUp.AutoSize = true;
            popUp.AutoSizeMode = AutoSizeMode.GrowAndShrink;
            //popUp.Size = new Size(calendar.Width + 4, calendar.Height + 4);//Scale.GetCalendarSize();
        }

        public void CalendarShow(Point point)
        {
            calendar.MaxDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day);
            calendar.MaxDate = calendar.MaxDate.Add(new TimeSpan(30, 0, 0, 0, 0));
            popUp.Location = new Point(point.X - 220, point.Y);
            calendar.Show();
            popUp.Show();
        }
    }
}
