﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;
//using System.Threading.Tasks;
using System.Windows.Forms;
using mshtml;

using nispi.WriteToThread;
using nispi.Menu;

namespace nispi.controlclass
{
    class ThreadListTabEvent : ThreadListTabMethod
    {
        ThreadListTabMenu threadListTabMenu;
        ThreadListTabMainMenu threadListTabMainMenu;

        public ThreadListTabEvent(ThreadListTabMenu threadListTabMenu)
        {
            this.threadListTabMenu = threadListTabMenu;

            //タブコントロールのイベント
            Const.form.threadListTabControlParts.MouseUp += new MouseEventHandler(threadView_tabControl_MouseUp);
            Const.form.threadListTabControlParts.MouseDown += new MouseEventHandler(threadView_tabControl_MouseDown);
            //Const.form.threadListTabControlParts.MouseDoubleClick += new MouseEventHandler(threadView_tabControl_MouseDoubleClick);
            //タブのメニュー
            threadListTabMenu.menuItemCloseTabParts.Click += new EventHandler(menuItemCloseTab_Click);

            threadListTabMenu.menuItemCloseAllTabParts.Click += new EventHandler(menuItemCloseAllTab_Click);

            threadListTabMenu.menuItemAddFavoriteParts.Click += new EventHandler(menuItemAddFavorite_Click);
            threadListTabMenu.menuItemAddFavoriteParts.Image = Resources.favorite;
            threadListTabMenu.menuItemAddFavoriteParts.ImageTransparentColor = Color.White;
            //threadListTabMenu.menuItemAddFavoriteParts.control.TextAlign = ContentAlignment.BottomLeft;

            threadListTabMenu.menuItemCreateNewThreadParts.Click += new EventHandler(menuItemCreateNewThread_Click);

            threadListTabMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            threadListTabMenu.menuItemOpenBrowserParts.Image = Resources.browser;
            threadListTabMenu.menuItemOpenBrowserParts.ImageTransparentColor = Color.White;

            threadListTabMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            threadListTabMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            threadListTabMenu.menuItemRelationThreadParts.Click += new EventHandler(menuItemRelationThread_Click);

            threadListTabMenu.menuItemOpenBBSParts.Click += new EventHandler(menuItemOpenBBSParts_Click);

            threadListTabMenu.menuItemReloadParts.Click += new EventHandler(menuItemReload_Click);
            threadListTabMenu.menuItemReloadParts.Image = Resources.reload;
            threadListTabMenu.menuItemReloadParts.ImageTransparentColor = Color.White;
        }

        public ThreadListTabEvent(ThreadListTabMainMenu threadListTabMainMenu)
        {
            this.threadListTabMainMenu = threadListTabMainMenu;

            //タブのメニュー
            threadListTabMainMenu.menuItemCloseTabParts.Click += new EventHandler(menuItemCloseTab_Click);

            threadListTabMainMenu.menuItemCloseAllTabParts.Click += new EventHandler(menuItemCloseAllTab_Click);

            threadListTabMainMenu.menuItemAddFavoriteParts.Click += new EventHandler(menuItemAddFavorite_Click);
            threadListTabMainMenu.menuItemAddFavoriteParts.Image = Resources.favorite;
            threadListTabMainMenu.menuItemAddFavoriteParts.ImageTransparentColor = Color.White;
            //threadListTabMainMenu.menuItemAddFavoriteParts.control.TextAlign = ContentAlignment.BottomLeft;

            threadListTabMainMenu.menuItemCreateNewThreadParts.Click += new EventHandler(menuItemCreateNewThread_Click);

            threadListTabMainMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            threadListTabMainMenu.menuItemOpenBrowserParts.Image = Resources.browser;
            threadListTabMainMenu.menuItemOpenBrowserParts.ImageTransparentColor = Color.White;

            threadListTabMainMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            threadListTabMainMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            threadListTabMainMenu.menuItemRelationThreadParts.Click += new EventHandler(menuItemRelationThread_Click);

            threadListTabMainMenu.menuItemOpenBBSParts.Click += new EventHandler(menuItemOpenBBSParts_Click);

            threadListTabMainMenu.menuItemReloadParts.Click += new EventHandler(menuItemReload_Click);
            threadListTabMainMenu.menuItemReloadParts.Image = Resources.reload;
            threadListTabMainMenu.menuItemReloadParts.ImageTransparentColor = Color.White;
        }

        private void threadView_tabControl_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                threadListTabMenu.contextMenuStripParts.Show(Const.form.threadListTabControlParts, e.Location);
            }
        }

        private void threadView_tabControl_MouseDown(object sender, MouseEventArgs e)
        {
            int selectNum = 0;
            if (e.Button == MouseButtons.Right)
            {
                for (int i = 0; i < Const.form.threadListTabControlParts.Count; i++)
                {
                    if (Const.form.threadListTabControlParts.GetTabRect(i).Contains(e.X, e.Y))
                    {
                        Const.form.threadListTabControlParts.SelectedIndex = i;
                        selectNum = i;
                        break;
                    }
                }
            }
            else
            {
                return;
            }
            SetTabMenu(selectNum);
        }

        private void SetTabMenu(int selectNum)
        {
            if ((MainFormConst.threadListTabMain.viewList[selectNum].datUrl != null) &&
                (MainFormConst.threadListTabMain.viewList[selectNum].datUrl.Length > 0))
            {
                threadListTabMenu.menuItemCloseTabParts.Enabled = true;
                threadListTabMenu.menuItemCloseAllTabParts.Enabled = true;
                threadListTabMenu.menuItemAddFavoriteParts.Enabled = true;
                threadListTabMenu.menuItemCreateNewThreadParts.Enabled = true;
                threadListTabMenu.menuItemOpenBrowserParts.Enabled = true;
                threadListTabMenu.menuItemCopyURLParts.Enabled = true;
                threadListTabMenu.menuItemCopyTitleParts.Enabled = true;
                threadListTabMenu.menuItemRelationThreadParts.Enabled = true;
                threadListTabMenu.menuItemReloadParts.Enabled = true;
                threadListTabMenu.menuItemOpenBBSParts.Enabled = true;
            }
            else
            {
                threadListTabMenu.menuItemCloseTabParts.Enabled = false;
                threadListTabMenu.menuItemCloseAllTabParts.Enabled = false;
                threadListTabMenu.menuItemAddFavoriteParts.Enabled = false;
                threadListTabMenu.menuItemCreateNewThreadParts.Enabled = false;
                threadListTabMenu.menuItemOpenBrowserParts.Enabled = false;
                threadListTabMenu.menuItemCopyURLParts.Enabled = false;
                threadListTabMenu.menuItemCopyTitleParts.Enabled = false;
                threadListTabMenu.menuItemRelationThreadParts.Enabled = false;
                threadListTabMenu.menuItemReloadParts.Enabled = false;
                threadListTabMenu.menuItemOpenBBSParts.Enabled = false;
            }
        }

        public void OpenTabMenu(MouseEventArgs e)
        {
            int selectNum = Const.form.threadListTabControlParts.SelectedIndex;

            SetTabMenu(selectNum);

            threadListTabMenu.contextMenuStripParts.Show(Const.form.threadListTabControlParts, e.Location);
        }
    }

    class ThreadListTabMethod
    {
        public ThreadViewCommon threadViewCommon;

        public ThreadListTabMethod()
        {
        }

        public bool CheckConsistency()
        {
            try
            {
                int index = Const.form.threadListTabControlParts.SelectedIndex;
                threadViewCommon = MainFormConst.threadListTabMain.viewList[index];
                return true;
            }
            catch
            {
                return false;
            }
        }
        public void menuItemOpenBBSParts_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string url = Util.DatUrlToBoardUrl(threadViewCommon.datUrl);
            MainFormConst.ShowBoard(url);
        }
        public void menuItemRelationThread_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            // 元のカーソルを保持
            Cursor preCursor = Cursor.Current;
            // カーソルを待機カーソルに変更
            Cursor.Current = Cursors.WaitCursor;

            string url = Util.DatUrlToBoardTextUrl(threadViewCommon.datUrl);
            
            //subject.txtをダウンロードして
            string str;
            DownloadSubject ds = new DownloadSubject();
            if (true == ds.DownloadSubjectText(url))
            {
                str = ds.httpResData;
            }
            else
            {
                Cursor.Current = preCursor;
                return;
            }


            if (str.Length <= 0)
            {
                Cursor.Current = preCursor;
                return;
            }

            //スレのタイトルの前5文字と被るスレッドを探して抽出
            string boardUrl = Util.DatUrlToBoardBBSUrl(threadViewCommon.datUrl);
            ThreadInfo newInfo = SubjectUtil.ParseSubjectLines(str, boardUrl);
            List<ThreadData> td = newInfo.threadDataList.Where(a => a.title.StartsWith(threadViewCommon.threadName.Substring(0, 6)) == true).ToList();
            //それをメニューで表示させる
            RelationThreadMenu rtm = new RelationThreadMenu(td.Count, td, Cursor.Position);
            Cursor.Current = preCursor;
            return;
        }

        public void menuItemCloseTab_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            threadViewCommon.dispoose();
        }

        public void menuItemCloseAllTab_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Const.form.threadListTabControlParts.SuspendLayout();

            try
            {
                for (int i = Const.form.threadListTabControlParts.Count - 1; i >= 0; i--)
                {
                    MainFormConst.threadListTabMain.viewList[i].dispooseAll();
                }
            }
            catch { ;}

            Const.form.threadListTabControlParts.ResumeLayout();

            //マジックコード
            //Const.form.mainForm.Size = new Size(Const.form.mainForm.Size.Width - 1, Const.form.mainForm.Size.Height - 1);
            //Const.form.mainForm.Size = new Size(Const.form.mainForm.Size.Width + 1, Const.form.mainForm.Size.Height + 1);
        }

        public void menuItemAddFavorite_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                string datUrl = threadViewCommon.datUrl;
                string title = threadViewCommon.threadName;
                string resNum = threadViewCommon.resNum;

                if (resNum.Length == 0)
                    resNum = "0";
                if ((datUrl.Length != 0) && (title.Length != 0))
                {
                    MainFormConst.boardListTabMain.favoriteBoardView.Register(datUrl, title, resNum);
                }

                //再読み込み
                Thread t = new Thread(new ThreadStart(MainFormConst.boardListTabMain.favoriteBoardView.worker));
                t.IsBackground = true;
                t.Start();
                return;
            }
            catch { ;}
        }

        public void menuItemCreateNewThread_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                WriteMain writeMainForm = new WriteMain(threadViewCommon.datUrl, threadViewCommon.threadName);
            }
            catch { ;}
        }

        public void menuItemOpenBrowser_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string url = threadViewCommon.datUrl;
            url = Util.DatUrlToThreadUrl(url);
            Process.Start(url);
        }

        public void menuItemCopyURL_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string url = threadViewCommon.datUrl;
            url = Util.DatUrlToThreadUrl(url);
            Clipboard.SetDataObject(url, true);
        }

        public void menuItemCopyTitle_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string title = threadViewCommon.threadName;
            Clipboard.SetDataObject(title, true);
        }

        public void menuItemReload_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Thread t = new Thread(new ThreadStart(threadViewCommon.ReloadThread));
            t.IsBackground = true;
            t.Start();

            return;
        }
        public void threadView_tabControl_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Thread t = new Thread(new ThreadStart(threadViewCommon.ReloadThread));
            t.IsBackground = true;
            t.Start();

            return;
        }
    }
}
   
