﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace nispi
{
    class BasicMapData
    {
        public static Dictionary<string, KokkaData> kokkaColorDic;
        public static Dictionary<string, KokkaData> kokkaNameDic;

        public static Dictionary<string, KokkaData> japanColorDic;
        public static Dictionary<string, KokkaData> japanNameDic;

        public static Dictionary<string, string> simpleNameDic;
        public static List<List<string>> simpleWordList;

        public static List<stringstring> kokkaList = new List<stringstring>();
        public static List<stringstring> kenList = new List<stringstring>();

        public BasicMapData()
        {
            //色からデータの辞書
            MakeKokkaColorDic("data", "world.txt", ref kokkaColorDic);
            MakeKokkaColorDic("data", "japan.txt", ref japanColorDic);
            //名前からデータの辞書
            MakeKokkaNameDic("data", "world.txt", ref kokkaNameDic);
            MakeKokkaNameDic("data", "japan.txt", ref japanNameDic);

            MakeSearchWord();

            MakeIndexViewList();
        }

        private void MakeIndexViewList()
        {
            try
            {
                string kokka = FileIO.ReadCurrentShiftJis("data", "国家と読みのペア.txt");
                string ken = FileIO.ReadCurrentShiftJis("data", "県と読みのペア.txt");

                string[] kokkas = kokka.Split('\r', '\n').Where(a => a.Length > 0).ToArray();
                string[] kens = ken.Split('\r', '\n').Where(a => a.Length > 0).ToArray();

                foreach (string temp in kokkas)
                {
                    if (temp.StartsWith("*****") == true)
                    {
                        kokkaList.Add(new stringstring(temp, ""));
                        continue;
                    }
                    else
                    {
                        string[] rows = temp.Split(',').Where(a => a.Length > 0).ToArray();
                        kokkaList.Add(new stringstring(rows[0], rows[1]));
                    }
                }
                foreach (string temp in kens)
                {
                    if (temp.StartsWith("*****") == true)
                    {
                        kenList.Add(new stringstring(temp, ""));
                        continue;
                    }
                    else
                    {
                        string[] rows = temp.Split(',').Where(a => a.Length > 0).ToArray();
                        kenList.Add(new stringstring(rows[0], rows[1]));
                    }
                }
            }
            catch { ;}
        }

        private void MakeKokkaNameDic(string dir, string file, ref Dictionary<string, KokkaData> nameDic)
        {
            string data = FileIO.ReadCurrentShiftJis(dir, file);
            nameDic = new Dictionary<string, KokkaData>();
            KokkaData nameData;
            string[] rows = data.Split(new char[] { '\r', '\n' });
            int i = 0;
            foreach (string line in rows.Where(a => a.Length > 0))
            {
                try
                {
                    string[] item = line.Split(new char[] { ',' });

                    if (item.Length == 7)
                    {
                        nameData = new KokkaData(item[0], item[1],
                            string.Format("{0},{1},{2}", item[4], item[5], item[6]),
                            new Point(Int32.Parse(item[2]), Int32.Parse(item[3])));
                    }
                    else
                    {
                        nameData = new KokkaData(item[0], item[1],
                            string.Format("{0},{1},{2}", item[4], item[5], item[6]),
                            new Point(Int32.Parse(item[2]), Int32.Parse(item[3])), item[7]);
                    }
                    if (nameDic.ContainsKey(item[1]) == true)
                        i += 1;
                    else
                        nameDic[item[1]] = nameData;
                }
                catch (System.Exception ex)
                {
                    //Const.debugForm.OutPutDebug("Map", ex);
                }
            }
        }

        private void MakeKokkaColorDic(string dir, string file, ref Dictionary<string, KokkaData> colorDic)
        {
            string data = FileIO.ReadCurrentShiftJis(dir, file);
            colorDic = new Dictionary<string, KokkaData>();
            KokkaData nameData;
            string[] rows = data.Split(new char[] { '\r', '\n' });

            foreach (string line in rows.Where(a => a.Length > 0))
            {
                try
                {
                    string[] item = line.Split(new char[] { ',' });

                    string color = string.Format("{0},{1},{2}", item[4], item[5], item[6]);

                    if (item.Length == 7)
                    {
                        nameData = new KokkaData(item[0], item[1],
                            color,
                            new Point(Int32.Parse(item[2]), Int32.Parse(item[3])));
                    }
                    else
                    {
                        nameData = new KokkaData(item[0], item[1],
                            color,
                            new Point(Int32.Parse(item[2]), Int32.Parse(item[3])), item[7]);
                    }

                    if (colorDic.ContainsKey(color) == true)
                    {
                        ;
                    }
                    else
                        colorDic[color] = nameData;
                }
                catch (System.Exception ex)
                {
                    //Const.debugForm.OutPutDebug("Map", ex);

                }
            }
        }


        private void MakeSearchWord()
        {
            simpleWordList = new List<List<string>>();
            simpleNameDic = new Dictionary<string, string>();
            string str = FileIO.ReadCurrentShiftJis("data", "search_word.txt");

            string[] rows = str.Split(new char[] { '\r', '\n' });

            foreach (string line in rows.Where(a => a.Length > 0 && !(a.StartsWith("*****"))))
            {
                string[] rows2 = line.Split(new char[] { ',' });
                List<string> list = rows2.ToList();

                simpleWordList.Add(list);

                if (simpleNameDic.ContainsKey(rows2[1]) == false)
                    simpleNameDic.Add(rows2[1], rows2[0]);
            }
        }
    }
}
