﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Xml.Linq;

namespace nispi
{
    class FormGuiData : nispi.OptionControl.CommonInEvent
    {
        public int Type1_Type2 = 0;

        public int MainFormLocation_X = 0;
        public int MainFormLocation_Y = 0;
        public int MainFormSize_X = 0;
        public int MainFormSize_Y = 0;
        public int MainFormMainDistance = 0;
        public int MainFormSubDistance = 0;


        public int MapFormLocation_X = 0;
        public int MapFormLocation_Y = 0;
        public int MapFormSize_X = 0;
        public int MapFormSize_Y = 0;
        public int MapFormMainDistance = 0;
        public int MapFormSubDistance = 0;


        private Mutex mutex = new Mutex(false, "FormGuiData");

        public FormGuiData()
        {
            GetXMLData();
        }

        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "FormGuiData.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "FormGuiData";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                Type1_Type2 = Int32.Parse(doc2.Element(ns + "Type1_Type2").Value);

                MainFormLocation_X = Int32.Parse(doc2.Element(ns + "MainFormLocation_X").Value);
                MainFormLocation_Y = Int32.Parse(doc2.Element(ns + "MainFormLocation_Y").Value);
                MainFormSize_X = Int32.Parse(doc2.Element(ns + "MainFormSize_X").Value);
                MainFormSize_Y = Int32.Parse(doc2.Element(ns + "MainFormSize_Y").Value);
                MainFormMainDistance = Int32.Parse(doc2.Element(ns + "MainFormMainDistance").Value);
                MainFormSubDistance = Int32.Parse(doc2.Element(ns + "MainFormSubDistance").Value);

                MapFormLocation_X = Int32.Parse(doc2.Element(ns + "MapFormLocation_X").Value);
                MapFormLocation_Y = Int32.Parse(doc2.Element(ns + "MapFormLocation_Y").Value);
                MapFormSize_X = Int32.Parse(doc2.Element(ns + "MapFormSize_X").Value);
                MapFormSize_Y = Int32.Parse(doc2.Element(ns + "MapFormSize_Y").Value);
                MapFormMainDistance = Int32.Parse(doc2.Element(ns + "MapFormMainDistance").Value);
                MapFormSubDistance = Int32.Parse(doc2.Element(ns + "MapFormSubDistance").Value);
            }
            catch { ;}

            if (MainFormLocation_X < 0)
                MainFormLocation_X = 0;
            if (MainFormLocation_Y < 0)
                MainFormLocation_Y = 0;

            if (MapFormLocation_X < 0)
                MapFormLocation_X = 0;
            if (MapFormLocation_Y < 0)
                MapFormLocation_Y = 0;

            mutex.ReleaseMutex();
        }

        public string ResetXML()
        {
            XNamespace ns = "FormGuiData";
            XElement doc = new XElement(ns + "Option",

                new XElement(ns + "Type1_Type2", "1"),

                new XElement(ns + "MainFormLocation_X", "100"),
                new XElement(ns + "MainFormLocation_Y", "100"),
                new XElement(ns + "MainFormSize_X", "900"),
                new XElement(ns + "MainFormSize_Y", "800"),
                new XElement(ns + "MainFormMainDistance", "200"),
                new XElement(ns + "MainFormSubDistance", "300"),
                
                 new XElement(ns + "MapFormLocation_X", "150"),
                new XElement(ns + "MapFormLocation_Y", "150"),
                new XElement(ns + "MapFormSize_X", "800"),
                new XElement(ns + "MapFormSize_Y", "600"),
                new XElement(ns + "MapFormMainDistance", "200"),
                new XElement(ns + "MapFormSubDistance", "400"));

            FileIO.SaveShiftJis("setting", "FormGuiData.xml", doc.ToString());

            return doc.ToString();
        }

        public void SaveFormToFile()
        {
            mutex.WaitOne();

            if (MainFormLocation_X < 0)
                MainFormLocation_X = 0;
            if (MainFormLocation_Y < 0)
                MainFormLocation_Y = 0;
            
            if (MapFormLocation_X < 0)
                MapFormLocation_X = 0;
            if (MapFormLocation_Y < 0)
                MapFormLocation_Y = 0;
            XNamespace ns = "FormGuiData";
            XElement doc = new XElement(ns + "Option",

                new XElement(ns + "Type1_Type2", Type1_Type2.ToString()),

                new XElement(ns + "MainFormLocation_X", MainFormLocation_X.ToString()),
                new XElement(ns + "MainFormLocation_Y", MainFormLocation_Y.ToString()),
                new XElement(ns + "MainFormSize_X", MainFormSize_X.ToString()),
                new XElement(ns + "MainFormSize_Y", MainFormSize_Y.ToString()),
                new XElement(ns + "MainFormMainDistance", MainFormMainDistance.ToString()),
                new XElement(ns + "MainFormSubDistance", MainFormSubDistance.ToString()),
                
                new XElement(ns + "MapFormLocation_X", MapFormLocation_X.ToString()),
                new XElement(ns + "MapFormLocation_Y", MapFormLocation_Y.ToString()),
                new XElement(ns + "MapFormSize_X", MapFormSize_X.ToString()),
                new XElement(ns + "MapFormSize_Y", MapFormSize_Y.ToString()),
                new XElement(ns + "MapFormMainDistance", MapFormMainDistance.ToString()),
                new XElement(ns + "MapFormSubDistance", MapFormSubDistance.ToString()));

            FileIO.SaveShiftJis("setting", "FormGuiData.xml", doc.ToString());

            mutex.ReleaseMutex();
        }
    }
}
