﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Text.RegularExpressions;

namespace nispi
{
    static class SubjectUtil
    {
        public static Regex SUBJECT_TXT_REGEXP1 = new Regex(@"((\d+)\.cgi),(.*)\((\d+)\)$");
        public static Regex SUBJECT_TXT_REGEXP2 = new Regex(@"((\d+)\.dat)<>(.*)\((\d+)\)$");

        public static Regex SUBJECT_TXT_REGEXP3 = new Regex(@"((\d+)\.cgi),(.*)\((\d+)\) \((\d+)\) \((\d+)\) \((.*)\) \((.*)\) \((.*)\)$");
        public static Regex SUBJECT_TXT_REGEXP4 = new Regex(@"(.*)<>(.*) \((\d+)\) \((\d+)\) \((\d+)\) \((.*)\) \((.*)\) \((.*)\) \((.*)\)$");

        //２ｃｈのデータの型から値を得る
        public static ThreadInfo ParseSubjectLines(string str, string boardUrl)
        {
            ThreadInfo threadInfo = new ThreadInfo();

            try
            {
                string[] rows = str.Split(new char[] { '\r', '\n' });

                foreach (string line in rows.Where(a => a.Length > 0))
                {
                    ParseSubjectLine(threadInfo, line, boardUrl);
                }
                return threadInfo;
            }
            catch
            {
                return null;
            }
        }

        //２ｃｈのデータの型から値を得る
        public static void ParseSubjectLine(ThreadInfo threadInfo, string line, string boardUrl)
        {
            Match subject = null;

            subject = SUBJECT_TXT_REGEXP1.Match(line);
            if (subject.Success == false)
                subject = SUBJECT_TXT_REGEXP2.Match(line);

            if (subject.Success == true)
            {
                string datFileName = subject.Groups[1].Value;
                string openTime = subject.Groups[2].Value;
                string title = subject.Groups[3].Value;
                string resNum = subject.Groups[4].Value;
                string orderNum = "";
                string datUrl = Util.MakeDatUrl(boardUrl, datFileName);
                threadInfo.AddList(orderNum, datUrl, title, resNum, openTime);
            }
        }
        //値を得るメソッド(独自の保存の型であるinfoが付くファイル用)
        public static ThreadInfo ParseSubjectInfoLines(string str, string fileName)
        {
            ThreadInfo threadList = new ThreadInfo();
            string[] rows = str.Split(new char[] { '\r', '\n' });

            try
            {
                foreach (string line in rows.Where(a => a.Length > 0))
                {
                    ParseSubjectInfoLine(threadList, line, fileName);
                }
                return threadList;
            }
            catch
            {
                return null;
            }
        }

        //値を得るメソッド(独自の保存の型であるinfoが付くファイル用)
        public static void ParseSubjectInfoLine(ThreadInfo threadList, string line, string fileName)
        {

            Match subject = null;
            //subject = SubjectUtil.SUBJECT_TXT_REGEXP3.Match(line);
            //if (subject.Success == false)
                subject = SubjectUtil.SUBJECT_TXT_REGEXP4.Match(line);

            if (subject.Success == true)
            {
                string datUrl = subject.Groups[1].Value;
                string title = subject.Groups[2].Value;
                string resNum = subject.Groups[3].Value;
                string readNum = subject.Groups[4].Value;
                string openTime = subject.Groups[5].Value;
                string nowUnixTime = subject.Groups[6].Value;
                string openTimeDateTime = subject.Groups[7].Value;
                string speed = subject.Groups[8].Value;
                string boardName = subject.Groups[9].Value;

                string orderNum = "";
                threadList.AddList(orderNum.ToString(), datUrl, title, resNum, readNum, openTime ,
                    openTimeDateTime, nowUnixTime, speed, fileName, boardName);
            }
        }

        public static string MakeSubjectInfoLine(ThreadData threadData)
        {
            string line = string.Format("{0}<>{1} ({2}) ({3}) ({4}) ({5}) ({6}) ({7}) ({8})\r\n",
                threadData.datUrl, threadData.title, threadData.resNum, threadData.readNum, threadData.openTime, threadData.nowUnixTime,
                threadData.openTimeString, threadData.speed, threadData.boardName);

            return line;
        }
    }
}

