﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください

using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Drawing;

using nispi.controlclass;

namespace nispi
{
    class FavoriteBoardIndexView : BoardIndexViewCommon
    {
        ButtonParts addButtonParts;

        public FavoriteBoardIndexView()
        {
            boardIndexControls = new BoardIndexControls(this as BoardIndexViewCommon);
            boardIndexControls.tabPageExParts.Text = "お気に入り";
            boardIndexControls.tabPageExParts.ToolTipText = "お気に入り";
            boardIndexControls.treeViewParts.Name = "favorite";

            Const.form.boardIndexTabControlParts.AddControl(boardIndexControls.tabPageExParts);

            //お気に入りタブだけのボタンを追加
            addButtonParts = ButtonPartsManager.Pop();
            addButtonParts.Location = new Point(160, 1);
            addButtonParts.Name = "control";
            addButtonParts.Size = new Size(26, 26);
            addButtonParts.SetToolTip("お気に入り追加");
            addButtonParts.Image = Resources.favorite;
            addButtonParts.Click += new EventHandler(AddButtonClick);
            boardIndexControls.tabPageExParts.AddControl(addButtonParts);

            //FavoriteBoardManager.LoadFavorite();
            LoadFavoriteBoardList();
        }

        public void AddButtonClick(object sender, EventArgs e)
        {
            Const.addFavoriteForm.ClearText();
            Const.addFavoriteForm.addFavoriteFormParts.Show();
            return;
        }

        public void LoadFavoriteBoardList()
        {
            Thread t2 = new Thread(new ThreadStart(LoadFavoriteBoardListThread));
            t2.IsBackground = true;
            t2.Start();
        }

        public void LoadFavoriteBoardListThread()
        {
            try
            {
                FavoriteBoardManager.LoadFavorite();
                if (FavoriteBoardManager.favoriteBoardList.Count == 0)
                    return; ;
                Const.form.mainForm.Invoke(new WriteFavoriteBoardList_Delegate(boardIndexControls.treeViewParts.WriteFavoriteBoardList), boardIndexControls.treeViewParts);
            }
            catch (System.Exception ex)
            {
                //Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }

        delegate void WriteFavoriteBoardList_Delegate(TreeViewParts treeViewParts);

    }
}
