﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;

using nispi.Menu;

namespace nispi.controlclass
{
    class SampleListViewEx : ListView
    {
        public SampleListViewEx ownerForm;

        protected override void WndProc(ref Message m)
        {
            const int WM_VSCROLL = 0x115;

            switch (m.Msg)
            {
                case WM_VSCROLL:
                    ownerForm.Focus();
                    break;
            }
            base.WndProc(ref m);
        }

        protected override bool DoubleBuffered { get { return true; } set { } }
    }

    partial class SampleListViewParts : ControlBase
    {
        private SampleListViewEx control;

        ColumnHeader columnText = new ColumnHeader();

        //private Color hitItemColor;

        public int[] oldItemNumList;

        //private ListViewItem hitItem = null;


        public ListViewItemParts[] items;

        public int itemSize = 0; 
        
        //public ListViewItemParts listViewItemParts;
        //public ListViewItemParts listViewItemParts2;

        public OptionControl.ColorSet columnFore = new OptionControl.ColorSet();
        public OptionControl.ColorSet columnBack = new OptionControl.ColorSet();

        private SolidBrush columnForeBrush;
        private SolidBrush columnBackBrush;
        
        public SampleListViewParts()
        {
            oldItemNumList = new int[0];
            //listView
            control = new SampleListViewEx();

            ImageList list = new ImageList();
            list.ImageSize = new Size(1, 18);
            control.SmallImageList = list;
            control.Font =
                new Font("Meiryo UI", 10.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)));
            control.Location = new Point(1, 27);
            control.Name = "listView1";
            control.TabIndex = 0;
            control.UseCompatibleStateImageBehavior = false;
            control.View = View.Details;
            control.FullRowSelect = true;

            this.controlBase = (System.Windows.Forms.Control)control;

            //ブラシ初期化
            columnForeBrush = new SolidBrush(Color.FromArgb(255, 255, 255, 255));
            columnBackBrush = new SolidBrush(Color.FromArgb(255, 0, 0, 0));

            columnText.Text = "カラム色";
            columnText.Name = "color";
            columnText.Width = 174;

            ColumnHeader[] colHeaderRegValue = {columnText};

            control.Columns.AddRange(colHeaderRegValue);

            control.VirtualMode = true;
            // Item数設定
            control.VirtualListSize = 1000;
            // 必須：描画に必要なListViewItemを返すイベント追加
            control.RetrieveVirtualItem += new RetrieveVirtualItemEventHandler(listView_RetrieveVirtualItem);
            control.MouseMove += new MouseEventHandler(listViewPart_MouseMove);
            control.ItemSelectionChanged += new ListViewItemSelectionChangedEventHandler(control_ItemSelectionChanged);
            control.OwnerDraw = true;
            control.DrawColumnHeader +=new DrawListViewColumnHeaderEventHandler(control_DrawColumnHeader);
            control.DrawSubItem += new DrawListViewSubItemEventHandler(control_DrawSubItem);
            this.control.ownerForm = control;
        }
        public void control_ItemSelectionChanged(object sender, ListViewItemSelectionChangedEventArgs e)
        {
            e.Item.Selected = false;
        }
        ///////////////////////////////////////////////////////////////
        public void SetFont(FontFamily font, float size)
        {
            this.control.Font = new Font(font, size);
        }

        public void ResetControl()
        {
            this.control.ownerForm = null;
        }

        public void AddItem(ListViewItemParts itemParts)
        {
            this.control.Items.Add(itemParts.control);
        }
        public void ItemsRemoveAt(int num)
        {
            this.control.Items.RemoveAt(num);
        }
        public void SelectItem(int num)
        {
            this.control.Items[num].Selected = true;
        }
        public int GetSelectedItemNum()
        {
            return this.control.SelectedItems[0].Index;
        }

        public void GetFocus(SampleListViewEx listViewEx)
        {
            if (control.ownerForm != null)
            {
                listViewEx.Focus();
            }
        }
    }

    class SampleListViewPartsManager
    {
        public static Stack<SampleListViewParts> buttonStack = new Stack<SampleListViewParts>();
        public static Mutex mutex = new Mutex(false, "SampleListViewPartManager");

        public static SampleListViewParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new SampleListViewParts());

            SampleListViewParts buttonParts = buttonStack.Pop();

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(SampleListViewParts buttonParts)
        {
            mutex.WaitOne();

            buttonParts.ResetControl();
            buttonParts.Update();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
    }
}
