﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    class PanelParts:ControlBase
    {
        private Panel control;

        public PanelParts()
        {
            control = new Panel();
            control.AutoScroll = true;

            this.controlBase = (System.Windows.Forms.Control)control;
        }
        public void Set_BorderStyle_FixedSingle()
        {
            control.BorderStyle = BorderStyle.FixedSingle;
        }
        /*public void SetDockFill()
        {
            this.control.Dock = DockStyle.Fill;
        }*/
        /*public void SetAnchorNonBottom()
        {
            this.control.Dock = DockStyle.None;

            this.control.Anchor = (AnchorStyles)
                ((AnchorStyles.Top) |
                (AnchorStyles.Left) | (AnchorStyles.Right));
        }*/

        public void SetAnchor4()
        {
            this.control.Dock = DockStyle.Fill;

            /*this.control.Anchor = (AnchorStyles)
                ((AnchorStyles.Top) | (AnchorStyles.Bottom) |
                (AnchorStyles.Left) | (AnchorStyles.Right));*/
        }

        public void ResetControl()
        {
            this.control.BorderStyle = BorderStyle.None;
        }
    }

    class PanelPartsManager
    {
        public static Stack<PanelParts> buttonStack = new Stack<PanelParts>();
        public static Mutex mutex = new Mutex(false, "PanelPartsManager");

        public static PanelParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new PanelParts());

            PanelParts buttonParts = buttonStack.Pop();

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(PanelParts buttonParts)
        {
            buttonParts.ResetControlBase();
            buttonParts.ResetControl();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
    }
}