﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

namespace nispi.controlclass
{
    class ToolStripMenuItemParts
    {
        public ToolStripMenuItem control;
        //private Color beforeColor;
        public ToolStripMenuItemParts()
        {
            control = new ToolStripMenuItem();
        }


        public void DropDownItemsAdd(ToolStripMenuItemParts toolStripMenuItemParts)
        {
            this.control.DropDownItems.Add(toolStripMenuItemParts.control);
        }

        public void DropDownItemsAdd(string text)
        {
            this.control.DropDownItems.Add(text);
        }

        public string Text
        {
            set
            {
                this.control.Text = value;
            }
            get
            {
                return this.control.Text;
            }
        }
        public string Name
        {
            set
            {
                this.control.Name = value;
            }
            get
            {
                return this.control.Name;
            }
        }

        public bool Enabled
        {
            set
            {
                this.control.Enabled = value;
            }
            get
            {
                return this.control.Enabled;
            }
        }

        public Image Image
        {
            set
            {
                this.control.Image = value;
            }
            get
            {
                return this.control.Image;
            }
        }
        public Color ImageTransparentColor
        {
            set
            {
                this.control.ImageTransparentColor = value;
            }
            get
            {
                return this.control.ImageTransparentColor;
            }
        }
        public event EventHandler Click
        {
            add
            {
                this.control.Click += value;
            }
            remove
            {
                this.control.Click -= value;
            }
        }
        public event EventHandler DropDownOpening
        {
            add
            {
                this.control.DropDownOpening += value;
            }
            remove
            {
                this.control.DropDownOpening -= value;
            }
        }
        public Color BackColor
        {
            set
            {
                this.control.BackColor = value;
            }
            get
            {
                return this.control.BackColor;
            }
        }
        public Color ForeColor
        {
            set
            {
                this.control.ForeColor = value;
            }
            get
            {
                return this.control.ForeColor;
            }
        }

        public void SetBitMap(string fileName)
        {
            Bitmap bitmap = new Bitmap(Image.FromFile(fileName));
            bitmap.MakeTransparent(Color.White);
            control.Image = bitmap;
        }

    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class ToolStripMenuItemPartsManager
    {
        public static LinkedList<ToolStripMenuItemParts> allFormList = new LinkedList<ToolStripMenuItemParts>();
        public static Stack<ToolStripMenuItemParts> tabPageStack = new Stack<ToolStripMenuItemParts>();
        public static Mutex mutex = new Mutex(false, "ToolStripMenuItemPartsManager");

        public static ToolStripMenuItemParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new ToolStripMenuItemParts());

            ToolStripMenuItemParts tabPage = tabPageStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(tabPage))
            {
                ChangeOutWard(tabPage);
                allFormList.AddLast(tabPage);
            }

            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(ToolStripMenuItemParts tabPage)
        {
            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }


        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (ToolStripMenuItemParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardMenu.MenuSample1ForeColorRed,
                    Const.opt.outWardMenu.MenuSample1ForeColorGreen,
                    Const.opt.outWardMenu.MenuSample1ForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardMenu.MenuSample1BackColorRed,
                    Const.opt.outWardMenu.MenuSample1BackColorGreen,
                    Const.opt.outWardMenu.MenuSample1BackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard(ToolStripMenuItemParts parts)
        {
            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardMenu.MenuSample1ForeColorRed,
                Const.opt.outWardMenu.MenuSample1ForeColorGreen,
                Const.opt.outWardMenu.MenuSample1ForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardMenu.MenuSample1BackColorRed,
                Const.opt.outWardMenu.MenuSample1BackColorGreen,
                Const.opt.outWardMenu.MenuSample1BackColorBlue);
        }
    }
}
