﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    class ListViewItemParts
    {
        public ListViewItem control;

        public ListViewItemParts()
        {
            control = new ListViewItem();
        }
        public ListViewItemParts(string[] strList)
        {
            control = new ListViewItem(strList);
        }
        public void SubItemsAddRange(string[] strList)
        {
            this.control.SubItems.AddRange(strList);
        }
        public void SubItemsClear()
        {
            this.control.SubItems.Clear();
        }
        public void SetFont(string fontName, float fontSize)
        {
            this.control.Font = new Font(fontName, fontSize, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
        }
        public string Text
        {
            set
            {
                this.control.Text = value;
            }
            get
            {
                return this.control.Text;
            }
        }
        public Color BackColor
        {
            set
            {
                this.control.BackColor = value;
            }
            get
            {
                return this.control.BackColor;
            }
        }
        public Color ForeColor
        {
            set
            {
                this.control.ForeColor = value;
            }
            get
            {
                return this.control.ForeColor;
            }
        }
        public string Name
        {
            set
            {
                this.control.Name = value;
            }
            get
            {
                return this.control.Name;
            }
        }
        //リストにあるスレッドのタイトルを得る
        public string SubItems_3_Text
        {
            get
            {
                return this.control.SubItems[3].Text;
            }
            set
            {
                this.control.SubItems[3].Text = value;
            }
        }
        //リストにあるスレッドの読んだ数を得る
        public string SubItems_4_Text
        {
            get
            {
                return this.control.SubItems[4].Text;
            }
            set
            {
                this.control.SubItems[4].Text = value;
            }
        }
        public string SubItems_5_Text
        {
            get
            {
                return this.control.SubItems[5].Text;
            }
            set
            {
                this.control.SubItems[5].Text = value;
            }
        }
        public string SubItems_6_Text
        {
            get
            {
                return this.control.SubItems[6].Text;
            }
            set
            {
                this.control.SubItems[6].Text = value;
            }
        }
    }

    class ListViewItemPartsManager
    {
        public static Stack<ListViewItemParts> buttonStack = new Stack<ListViewItemParts>();
        public static Mutex mutex = new Mutex(false, "ListViewItemPartsManager");

        public static ListViewItemParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new ListViewItemParts());

            ListViewItemParts buttonParts = buttonStack.Pop();

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(ListViewItemParts buttonParts)
        {
            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
    }
}